#include "mbed.h"
#include "USBSerial.h"
#include "MATSUbed.h"

USBSerial pc(0x1f00,0x2012, 0x0001,false);

BusOut myled(LED1, LED2, LED3, LED4);

//DigitalIn sw1(ISP0);
//DigitalIn sw2(ISP1);

InterruptIn USB_ISP_bt(ISP0);

// ISP0ボタンを押すとUSB ISPモードに入る設定
void enter_USB_ISP(){
    pc.printf("enter ISP\n");
    NVIC_SystemReset();
}

int main() {
    USB_ISP_bt.mode(PullUp);
    USB_ISP_bt.fall(&enter_USB_ISP);
    
    myled = 0b0001;
    
    while(1){
        if(myled < 0b1000){
            wait(0.5);
            myled = myled << 1;
        }else{
            while(myled != 0b0001) {
                wait(0.5);
                myled = myled >> 1;
            }
        }
        pc.printf("hello world \r\n");
    }
}
