/* servo motor program - biorbotics group 8 */

#include "Servo.h"
#include "mbed.h"
#include "HIDScope.h"
#include "QEI.h"
#include "MODSERIAL.h"
#include "BiQuad.h"
#include "FastPWM.h"

MODSERIAL pc(USBTX, USBRX); //connect pc
Servo myservo(D3); //the servo motor is connected to pin D3 on the BioRobotics shield
DigitalIn extButton1 (D2);
//Button that will be used to control the servo motor
InterruptIn button2(SW2); //when this button is pushed for the first time, the servo motor rotates to show the card to the user, when the button is pushed for the second time the servo motor rotates the card away from the user

bool showcard=0;
bool butt1;
Ticker Servoticker;

void changeservo()
{    
    butt1= extButton1.read();
    if (butt1==1){
    myservo.SetPosition(2000);
    showcard=!showcard;
    }
    
    else {
    myservo.SetPosition(1000);
    showcard=!showcard;
        }    
}

int main()
{
    
    pc.baud(115200);
    pc.printf("Starting...");
    
    myservo.Enable(1000,20000);
    
    Servoticker.attach(changeservo,0.01);
    extButton1.mode(PullUp);
   
    
    while(true) {
        pc.printf("Button1: %i \r\n", butt1);
        wait(0.5);
    }
}





