#include "mbed.h"
#include "HIDScope.h"
//#include "QEI.h"
#include "MODSERIAL.h"
//#include "BiQuad.h"
//#include "FastPWM.h"
#include <string> 

        
DigitalOut ledr(LED_RED);
DigitalOut ledg(LED_GREEN);
DigitalOut ledb(LED_BLUE);
PwmOut led1(D10);
DigitalIn button1(D2);
AnalogIn potmeter(A1);
DigitalIn sw(SW2);
MODSERIAL pc(USBTX, USBRX);

HIDScope scope(2); //Going to send 2 channels of data. To access data go to 'http:/localhost:18082/' after starting HIDScope application.
Ticker AInTicker;
AnalogIn aIn1(A1);

volatile float x;
volatile float x_prev=0;
volatile float y; //filtered 'output' of Read Analog

void ReadAnalogInAndFilter()
{
    x=aIn1; //capture data
    scope.set(0,x); //store data in first element of scope memory (store 1st data point)
    y=(x_prev+x)/2.0; //averaging filter
    scope.set(1,y); //store data in second element of scope memory (store second data point)
    x_prev= x; //prepare for next round
    
    scope.send(); //send what's in scope memory to PC
}

int main()
{
    pc.baud(115200);
    pc.printf("\r\nStarting...\r\n\r\n");
  
    AInTicker.attach(&ReadAnalogInAndFilter, 0.01);
    while(true){/*do nothing. You could use y here if you wish*/};

}