#include "mbed.h"
//#include "HIDScope.h"
#include "QEI.h"
#include "MODSERIAL.h"
//#include "BiQuad.h"
#include "FastPWM.h"

// Button and potmeter control
InterruptIn button1(D11);
InterruptIn button2(D10);
AnalogIn potmeter(A0);

// Encoder
DigitalIn encA(D13);
DigitalIn encB(D12);
QEI encoder(D13,D12,NC,64,QEI::X4_ENCODING);

// Motor
DigitalOut motor2Direction(D4);
FastPWM motor2Power(D5);
DigitalOut motor1Direction(D7);
FastPWM motor1Power(D6);

// PC connection
MODSERIAL pc(USBTX, USBRX);

// Intializing tickers
Ticker motorTicker;
Ticker encoderTicker;

const float maxVelocity = 7.958701 * 0.75; // 76 RPM to rad/s at 75% efficiency due to 9V instead of 12V
const float PWM_period = 1e-6;

volatile int counts; // Encoder counts
volatile int countsPrev = 0;
volatile int deltaCounts;

// motor1Direction = 1;
volatile int motor1Toggle = 1;

float factorin = 6.23185/64; // Convert encoder counts to angle in rad
float gearratio = 131.25; // Gear ratio of gearbox

float getRefVelocity()
{
    float refVelocity;

    if (button1) {
        refVelocity = potmeter.read() * maxVelocity;
    } else {
        refVelocity = potmeter.read() * maxVelocity * -1;
    }
    return refVelocity;
}

void motorControl()
{
    float potValue = potmeter.read();
    motor1Power.pulsewidth(potValue * PWM_period * motor1Toggle);
}

void readEncoder()
{
    counts = encoder.getPulses();
    deltaCounts = counts - countsPrev;

    countsPrev = counts;
}

void flipDirection()
{
    motor1Direction = !motor1Direction;
}

void toggleMotor()
{
    motor1Toggle = !motor1Toggle;
}

int main()
{
    pc.baud(115200);
    pc.printf("\r\nStarting...\r\n\r\n");

    motor1Power.period(PWM_period);

    motorTicker.attach(motorControl, 0.01);

    float T_encoder = 0.1;
    encoderTicker.attach(readEncoder, T_encoder);

    button1.fall(&flipDirection);
    button2.fall(&toggleMotor);

    while (true) {
        float potValue = potmeter.read(); // Read potmeter
        float angle = counts * factorin / gearratio; // Angle of motor shaft in rad
        float omega = deltaCounts / T_encoder * factorin / gearratio; // Angular velocity of motor shaft in rad/s

        pc.printf("Potmeter: %f \r\n", potValue);
        pc.printf("Counts: %i   DeltaCounts: %i\r\n", counts, deltaCounts);
        pc.printf("Angle:  %f   Omega:       %f\r\n", angle, omega);

        wait(0.5);
    }
}
