#include "mbed.h"

BusOut myled_port(p21,p22,p23,p24,LED4,LED3,LED2,LED1,p25);
//                LSB                                 MSB
// A = p21  B = p22  C = p23  D = p24

// myled_port = 0x p21 p22 p23 p24 LED4 LED3 LED2 LED1 p25;
//                  A   B   C   D                      Enable
//                  LSB                                MSB
//myled_port = 0x111;
//               ELP 
/*
E....Enable für den Schrittmotor
ACHTUNG E=0 ....aktiv (invertiert !!)


Wave-Drive-Betrieb (Wellenschritt-Modus)rechts
    A B C D E
    1 0 0 0 0         
    0 1 0 0 0
    0 0 1 0 0
    0 0 0 1 0
----------------------------------       
Wave-Drive-Betrieb (Wellenschritt-Modus)links
    A B C D E
    0 0 0 1 0         
    0 0 1 0 0
    0 1 0 0 0
    1 0 0 0 0
----------------------------------       
Vollschritt rechts
    1 2 4 8
    A B C D E
    1 1 0 0 0   = 0x3     
    0 1 1 0 0   = 0x6 
    0 0 1 1 0   = 0xC 
    1 0 0 1 0   = 0x9 
------------------------------------
Halbschritt rechts
    1 2 4 8
    A B C D E
    1 0 0 0 0   = 0x1     
    1 1 0 0 0   = 0x3 
    0 1 0 0 0   = 0x2
    0 1 1 0 0   = 0x6
    0 0 1 0 0   = 0x4
    0 0 1 1 0   = 0xC 
    0 0 0 1 0   = 0x8 
    1 0 0 1 0   = 0x9

*/

Serial pc(USBTX, USBRX); // tx, rx
char   ch;


int zeit=1;  // sec
int zahl,schritte=5;

 


int main() {
    pc.printf("Schrittmotor steuern mittels Raspberry PI!\r\n");
    pc.printf("DI Franz Wolf (WF)\r\n");
    pc.printf("Wave-Drive-Betrieb rechts: Dr\x81cken Sie 1 <n>\r\n");
    pc.printf("Wave-Drive-Betrieb links : Dr\x81cken Sie 2 <n>\r\n");
    pc.printf("Vollschritte-Betrieb: Dr\x81cken Sie 3 <n>\r\n");
    pc.printf("Halbschritt-Betrieb: Dr\x81cken Sie 4 <n>\r\n");
    
    // printf("Die Umlaute: \x81 \x84 \x94 \x8E \x99 \x9A \xE1");//ü ä ö Ä Ö Ü ß

    
    
    while(1) {
        
        ch = pc.getc();
        
        switch (ch) {
            case '1':  //Wave-Drive-Betrieb (Wellenschritt-Modus)rechts
                for(zahl=1; zahl<=schritte; zahl++)
                    {
                        myled_port = 0x011;
                        wait(zeit);
                        myled_port = 0x012;  
                        wait(zeit);
                        myled_port = 0x004;
                        wait(zeit);
                        myled_port = 0x008;
                        wait(zeit);
                    }  
                    break;
        
                case '2': //Wave-Drive-Betrieb (Wellenschritt-Modus)links
                    for(zahl=1; zahl<=schritte; zahl++)
                    {
                        myled_port = 0x018;
                        wait(zeit);
                        myled_port = 0x014;  
                        wait(zeit);
                        myled_port = 0x002;
                        wait(zeit);
                        myled_port = 0x001;
                        wait(zeit);
                    }
                    break;
                    
                case '3': //Wave-Drive-Betrieb (Wellenschritt-Modus)links
                    for(zahl=1; zahl<=schritte; zahl++)
                    {
                        myled_port = 0x013;
                        wait(zeit);
                        myled_port = 0x016;  
                        wait(zeit);
                        myled_port = 0x00C;
                        wait(zeit);
                        myled_port = 0x009;
                        wait(zeit);
                    }
                    break;
                    
                case '4': //Wave-Drive-Betrieb (Wellenschritt-Modus)links
                    for(zahl=1; zahl<=schritte; zahl++)
                    {
                        myled_port = 0x011;
                        wait(zeit);
                        myled_port = 0x013;  
                        wait(zeit);
                        myled_port = 0x002;
                        wait(zeit);
                        myled_port = 0x006;
                        wait(zeit);
                        myled_port = 0x004;
                        wait(zeit);
                        myled_port = 0x01C;
                        wait(zeit);
                        myled_port = 0x018;  
                        wait(zeit);
                        myled_port = 0x009;
                        wait(zeit);
                    }
                    break;   
                               
                }  
                

                
          
  /*      
        
        if (ch == 'a') {  // Motor aus
        
        wait(zeit);
        myled_port = 0x111;
        wait(zeit);
        myled_port = 0x112;  
      wait(zeit);
        myled_port = 0x104;
        wait(zeit);
        myled_port = 0x108;
        
         wait(zeit);
        myled_port = 0x118;
        wait(zeit);
        myled_port = 0x114;  
         wait(zeit);
        myled_port = 0x102;
        wait(zeit);
        myled_port = 0x101;
*/     
        
    }
}
