/*M0-BOARD LPC11U24 VERSION 1.0 WF 01_2015
BULME Graz / Elektronik
Autor: DI Franz Wolf

RTC NXP
PCF 8563

Datei: WF_LDR_V1/main.cpp
*/

#include "mbed.h"


#define RTC8563_ADR 0xA2
 
#define CONTROL1 0x00
#define CONTROL2 0x01
#define SECONDS 0x02
#define MINUTES 0x03
#define HOURS 0x04
#define DAYS 0x05
#define WEEKDAYS 0x06
#define MONTHS 0x07
#define YEARS 0x08
#define MINUTE_ALARM 0x09
#define HOUR_ALARM 0x0A
#define DAY_ALARM 0x0B
#define WEEKDAY_ALARM 0x0C
#define CLOCKOUT_FREQ 0x0D
#define TIMER_CINTROL 0x0E
#define TIMER 0x0F
#define _READ 0x01

InterruptIn alarm(P1_28);

DigitalOut myled1(LED1);
 
Serial pc(USBTX, USBRX); // tx, rx 
I2C i2c(p28, p27);

char year, month, day, week;
char hour, minute, sec;

char hour_a, minute_a, week_a;
 

char week_val;
char week_chr[7][4] = {"MON","TUE","WED","THU","FRI","SAT","SUN"};

//************************************  
// write I2C
void rtc_write(char address, char value)
{
    i2c.start();
    i2c.write(RTC8563_ADR);
    i2c.write(address);
    i2c.write(value);
    i2c.stop();
}

// read I2C 
char rtc_read(char address)
{
    char value;
    i2c.start();
    i2c.write(RTC8563_ADR);
    i2c.write(address);
    i2c.start();
    i2c.write(RTC8563_ADR | _READ);
    value = i2c.read(0);
    i2c.stop();
    
    return value;
}

//Zeit einstellen der RTC  
void rtc_init()
{
    pc.printf("Setting up RTC\n");
    
    // Formatierung
    // 2015/01/24
    // 10:32:00 
    
    week_val = 0x05;   // SAT   
    rtc_write(CONTROL1, 0x20); //stop
    rtc_write(CONTROL2, 0x00);
    rtc_write(YEARS, (0x15) ); 
    rtc_write(MONTHS, (0x01));
    rtc_write(DAYS, (0x24));
    rtc_write(HOURS, (0x10));
    rtc_write(MINUTES, (0x34));
    rtc_write(SECONDS, (0x00));
    rtc_write(WEEKDAYS, week_val);
    rtc_write(CLOCKOUT_FREQ, 0x00); // 0x83 = TE on & 1Hz
    rtc_write(TIMER_CINTROL, 0x00);
    rtc_write(CONTROL1, 0x00); //start
}
//************************************  

//Zeit einstellen der RTC  
void rtc_alarm()
{
    pc.printf("Setting up RTC\n");
    
    // Formatierung
    // 2015/01/24
    // 10:32:00 
    
  //  week_val = 0x05;   // SAT   
    rtc_write(CONTROL1, 0x20); //stop
    rtc_write(CONTROL2, 0x0F); // alarm AF alarm flag bit
    rtc_write(DAY_ALARM, (0x26) );
    rtc_write(HOUR_ALARM, (0x19));
    rtc_write(MINUTE_ALARM, (0x27));
    rtc_write(WEEKDAY_ALARM, (0x00));
    rtc_write(CONTROL1, 0x00); //start
    
    
}
//************************************  

void push1() // Interruptfunktion alarm
{
pc.printf("ALARM" );    
myled1= 1;
}

int main() {
    
    alarm.rise(&push1);
    rtc_alarm();
    
    //RTC_init
    //rtc_init();

    pc.printf("RTC8563 CLOCK\n" );
    wait(2.0);
    
    myled1= 0;

    while(1) { 

      //lesen der Parameter vom RTC
        year = rtc_read(YEARS);
        month = rtc_read(MONTHS);
        day = rtc_read(DAYS);
        week = rtc_read(WEEKDAYS);
        hour = rtc_read(HOURS);
        minute = rtc_read(MINUTES);
        sec = rtc_read(SECONDS);
        

        hour_a = rtc_read(HOUR_ALARM);
        minute_a = rtc_read(MINUTE_ALARM);
        week_a = rtc_read(WEEKDAY_ALARM);
        
        


        
                        
     //Datum Ausgabe                      
     pc.printf("20%x%x/%x%x/%x%x %s\n",
            ((year >> 4) & 0x03) , (year & 0x0F) , 
                ((month >> 4) & 0x01), (month & 0x0F) , 
                    ((day >> 4) & 0x03), (day & 0x0F) , 
                        week_chr[week & 0x07]);
                        
      //Zeit Ausgabe                        
    pc.printf("%x%x:%x%x:%x%x\n",
            ((hour >> 4) & 0x03), (hour & 0x0F), 
                (minute >> 4), (minute & 0x0F) , 
                    (sec >> 4), (sec & 0x0F) );  
     
     pc.printf("ALARM RTC8563 CLOCK\n" );               
    
        pc.printf("%x%x:%x%x %s\n",
            ((hour_a >> 4) & 0x03), (hour_a & 0x0F), 
                (minute_a >> 4), (minute_a & 0x0F),
                 week_chr[week_a & 0x07]);
                                     
                    
        wait(1.0);
    }
}

 
