/*M0-BOARD LPC11U24 VERSION 1.0 WF 01_2015
BULME Graz / Elektronik
RGB - LED
Datei: WF_RGB_Ampel/main.cpp
*/

#include "mbed.h"
PwmOut g(p5); // Definition LED grün, PWM
PwmOut b(p34); // Definition LED blau, PWM
PwmOut r(p36); // Definition LED rot, PWM

// Definition der Taster (Switches)
DigitalIn  sw1(P0_15);  // SW1 -> sein IO Pin ist laut Schaltplan der P0_15
DigitalIn  sw2(P0_10);  // Die Pins werden hier mit DigitalIn belegt ! 
DigitalIn  sw3(P0_23);  // Die Pins werden hier mit DigitalIn belegt !

// definition der Zustände
typedef enum { a_rot, a_blau, a_gruen, temp} state_t ;
state_t state = a_rot;

// Funktions-Prototype
void farbe(int gruen, int blau, int rot);
void stateMachine();

int main()
{
    farbe(1,1,0);
    while(1)
    {       
      if (sw1==1) {
          stateMachine();
      }    
    }
}  
    
// Function farbe definieren
void farbe(int gruen, int blau, int rot)
{
    g=gruen; // LED gruen  
    b=blau; // LED blau
    r=rot; // LED rot
} 

// Function Zustnadsmaschine
void stateMachine()
{
    switch( state ) {
        case a_rot:
            farbe(1,1,0);
            wait(2);
            state = a_blau;
            //break;
            
        case a_blau:
            farbe(1,0,1);
            wait(2);
            state = a_gruen;
            //break;
            
        case a_gruen:
            farbe(0,1,1);
            wait(2);
            state = a_rot;
            //break;  
            
        case temp:
            farbe(1,1,0);
            break; 
              
    }
}
