#include "mbed.h"
#include "XBeeLib.h"

#define MAXPULSE    10000                               // the maximum pulse we'll listen for - 10 milliseconds 
#define NUMPULSES    200                                // max IR pulse pairs to sample
#define RESOLUTION     1                                // time between IR measurements ~1uS

// we will store up to 200 pulse pairs (this is -a lot-)
uint16_t pulses[200][2];                                // pair is high and low pulse
uint16_t currentpulse = 0;                              // index for pulses we're storing
uint32_t irCode = 0;
Serial pc(USBTX, USBRX);                                // tx, rx
DigitalIn IRpin (p8);                                   // Listen to IR receiver on Trinket/Gemma pin D2

int listenForIR(void);                                  // IR receive code
void printcode(void);                                   // Print IR code in HEX

using namespace XBeeLib;

int main(void)
{
    pc.printf("Ready to decode IR!\n");
    XBeeZB xbee = XBeeZB(RADIO_TX, RADIO_RX, RADIO_RESET);
    RadioStatus radioStatus;

    while (1) {

        int numpulse=listenForIR();                     // Wait for an IR Code
        RemoteXBeeZB remoteDevice = RemoteXBeeZB(0x0013A20041642F34);
        // Process the pulses to get a single number representing code
        for (int i = 0; i < 32; i++) {
            irCode=irCode<<1;
            if((pulses[i][0] * RESOLUTION)>0&&(pulses[i][0] * RESOLUTION)<500) {
                irCode|=0;
            } else {
                irCode|=1;
            }
        }

        // Print IR code
        wait_ms(100);

        if (irCode ==  0xc489211e) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutLow);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutLow);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutLow);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutLow);    //d3
        }
                if (irCode ==  0xc489112e) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutHigh);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutLow);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutLow);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutLow);    //d3
        }
                if (irCode ==  0xc489310e) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutLow);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutHigh);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutLow);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutLow);    //d3
        }
                if (irCode ==  0xc4890936) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutHigh);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutHigh);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutLow);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutLow);    //d3
        }
                if (irCode ==  0xc489201f) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutLow);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutLow);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutHigh);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutLow);    //d3
        }
                if (irCode ==  0xc489102f) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutHigh);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutLow);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutHigh);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutLow);    //d3
        }
                if (irCode ==  0xc489300f) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutLow);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutHigh);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutHigh);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutLow);    //d3
        }
                if (irCode ==  0xc4890837) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutHigh);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutHigh);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutHigh);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutLow);    //d3
        }
                if (irCode ==  0xc4892817) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutLow);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutLow);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutLow);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutHigh);    //d3
        }
                if (irCode ==  0xc4891827) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutHigh);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutLow);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutLow);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutHigh);    //d3
        }
                if (irCode ==  0xc4893807) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutLow);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutHigh);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutLow);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutHigh);    //d3
        }
                if (irCode ==  0xc489043b) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutHigh);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutHigh);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutLow);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutHigh);    //d3
        }
                if (irCode ==  0xc489241b) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutLow);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutLow);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutHigh);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutHigh);    //d3
        }
                if (irCode ==  0xc4892996) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutHigh);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutLow);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutHigh);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutHigh);    //d3
        }
                if (irCode ==  0xc489003f) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutLow);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutHigh);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutHigh);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutHigh);    //d3
        }
                if (irCode ==  0xc4890c33) {
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO12, DigitalOutHigh);    //d0
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO4, DigitalOutHigh);    //d1  
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO0_AD0, DigitalOutHigh);    //d2
              radioStatus = xbee.set_pin_config(remoteDevice, XBeeZB::DIO3_AD3, DigitalOutHigh);    //d3
        }

    }  //end of main loop
}


int listenForIR(void)                                   // IR receive code
{
    currentpulse = 0;
    while (1) {
        unsigned int highpulse, lowpulse;               // temporary storage timing
        highpulse = lowpulse = 0;                       // start out with no pulse length

        while (IRpin==1) {                              // got a high pulse
            highpulse++;
            wait_us(RESOLUTION);
            if (((highpulse >= MAXPULSE) && (currentpulse != 0))|| currentpulse == NUMPULSES) {
                return currentpulse;
            }
        }
        pulses[currentpulse][0] = highpulse;

        while (IRpin==0) {                              // got a low pulse
            lowpulse++;
            wait_us(RESOLUTION);
            if (((lowpulse >= MAXPULSE) && (currentpulse != 0))|| currentpulse == NUMPULSES) {
                return currentpulse;
            }
        }
        pulses[currentpulse][1] = lowpulse;
        currentpulse++;
    }
}
 
