#include "mbed.h"
#include "LM75B.h"
#include "MSS.h"
#include "MPL3115A2.h"
#define MPL3115A2_I2C_ADDRESS (0x60)

Serial pc(USBTX,USBRX);

#include "C12832.h"
C12832 lcd(p5, p7, p6, p8, p11);
LM75B sensor(p28,p27);
MPL3115A2 mpl(PIN_SDA, PIN_SCL, MPL3115A2_I2C_ADDRESS) ;

int main() {
    double alt, bar, temp ;
    mpl.setBarIn((unsigned short)(101800/2));
    
    sensor.open();
    
    while(1) {
        alt = mpl.getAltitude() ;
        bar = mpl.getPressure() ;
        temp = mpl.getTemperature() ;
        lcd.cls();
        lcd.locate(0,1);
        lcd.printf("ALTI,    BAR,  TEMP",alt, bar, temp) ;
        lcd.locate(0,10);
        lcd.printf("%5.2f, %5.2f, %5.2f %5.3f",alt, bar, temp,sensor.temp()) ;
        wait(1) ;
    }
}
