/*
* Los Putacos
* Copyright (C) 2017, All rights reserved.
* ________________________________________
*
* Created by: Gustavo Campana, Michael Schmidt, Miguel Lopez
*       Date: 12-Oct-2017
*    Version: V0.1
*/
//-----------------------------------------------------------------

//-----------------------------------------------------------------
// Includes
#include "event.h"

//-----------------------------------------------------------------

//-----------------------------------------------------------------
void ReadBattery(void)
{
    Battery_Status = VSense.read()/0.21 - 3;        // Read Voltage Level above Critial Value (> 3V)
    Power_Consumption = ISense.read() * 3.3;        // Read Current Level and calculate Power_Consumption
    PC.printf("Battery_Status = %.3fV - %.3fmW\n", Battery_Status + 3, Power_Consumption);      // Show Total Voltage Level

    if (Battery_Status > 1) {   // More than 1V Voltage Difference
        LED_Red1 = 0;           // Turn ON both Red LEDs
        LED_Red2 = 0;
    } else if ((Battery_Status > 0.25) && (Battery_Status < 1)) {       // Between 0.25V and 1V Voltage Difference
        LED_Red1 = 0;       // Turn ON one Red LEDs
        LED_Red2 = 1;
    } else {
        LED_Red1 = 1;       // Turn off both Red LEDs
        LED_Red2 = 1;
    }
}
//-----------------------------------------------------------------

//-----------------------------------------------------------------
void ReceiveCommand(void)
{
    response = Socket_TCP.connect("192.168.43.96", 8080);       // Connect to TCP Server at 192.168.43.96/8080

    if (0 == response) {            // Server Available & Connection Successful
        if (Socket_TCP.recv(Data_Buffer, sizeof Data_Buffer) > 0) {         // TCP Socket Data Available
            if (strlen(Data_Buffer) == 9) {                                 // Check Package Length (correct: len = 9)
                if ((Data_Buffer[0] == '#') && (Data_Buffer[6] == ',')) {       // Check for "#" and "," at specific Positions
                    if (strstr(Data_Buffer, DeviceNr) != NULL) {                // Check for valid DeviceNr in Package
                        Ticker_ReadBattery.detach();            // Stop "ReadBattery" Thread                    
                        Ticker_ReceiveCommand.detach();         // Stop "ReceiveCommand" Thread
                        
                        Time_Buffer[0] = Data_Buffer[7];        // Read 1st Time Byte from Buffer
                        Time_Buffer[1] = Data_Buffer[8];        // Read 2nd Time Byte from Buffer
                        Requested_Time = atoi(Time_Buffer);     // Requested Time by Command
                        
                        PC.printf("\nCommand Received - Requested Time: %d\n", Requested_Time);
                        Buzzer = 0.5;       // Enable Buzzer at 50% DutyCycle
                        wait(0.5);          // Pause for Buzzing
                        Buzzer = 0;         // Disable Buzzer
                        CheckCommandDone_Flag = 1;              // Set Flag for Measurement Start
                    }
                }
            }
        }
    }
}
//-----------------------------------------------------------------

//-----------------------------------------------------------------
void ReadIMU(void)
{
    Time_Data = TimeStamp.read_ms();        // Read TimeStamp Data

    if (Time_Data <= Requested_Time * 1000) {       // Check Time Elapsed
        imu.read_acc();         // Read Accelerometer Data

        Data_Storage_MIC[writePointer_MIC++] = Micro_1.read_u16();      // Store Microphone Data
        Data_Storage[writePointer++] = imu.accelerometer_data[2];       // Store Z-Axis Accelerometer Data
        Data_Storage[writePointer++] = imu.accelerometer_data[1];       // Store Y-Axis Accelerometer Data
        Data_Storage[writePointer++] = imu.accelerometer_data[0];       // Store X-Axis Accelerometer Data
        Data_Storage[writePointer++] = Time_Data;                       // Store Time Data
    } else {
        Ticker_IMU.detach();        // Stop "ReadIMU" Thread
        TimeStamp.stop();           // Stop TimeStamp
        TimeStamp.reset();          // Reset TimeStamp

        TimeStamp.start();          // Start TimeStamp
        ReadIMUDone_Flag = 1;       // Set Flag for Sending Start
    }
}
//-----------------------------------------------------------------

//-----------------------------------------------------------------