/*
* Los Putacos
* Copyright (C) 2017, All rights reserved.
* ________________________________________
*
* Created by: Gustavo Campana, Michael Schmidt, Miguel Lopez
*       Date: 11-Oct-2017
*    Version: V0.1
*/

//-----------------------------------------------------------------
#ifndef CONFIGURATION_H_
#define CONFIGURATION_H_

// Microcontroller definition - Comment the Version not used
#define STM32F446RET6 1

// Debug mode
#define DEBUG_MODE  0
//-----------------------------------------------------------------

//-----------------------------------------------------------------
// PIN Defines
#ifdef STM32F446RET6
    // Wifi SSID & Password
    #define WiFi_SSID "OnePlus3"
    #define WiFi_Pass "mahandi00"

    // ESP8266 Communication Variables
    #define ESP_TX PC_6
    #define ESP_RX PC_7
        
    // IMU Variables
    #define IMU_SCK PB_13
    #define IMU_MISO PB_14      // SDO - Serial Data Output - MISO
    #define IMU_MOSI PB_15      // SDI - Serial Data Input - MOSI
    #define IMU_CS PB_1
    
    // Buzzer PWM Output
    PwmOut Buzzer(PB_4);
    
    // Voltage & Current Sensor
    AnalogIn VSense(PA_5);
    AnalogIn ISense(PA_6);
    
    //Analog Input
    AnalogIn Micro_1(PC_4);
    AnalogIn Micro_2(PC_0);
    
    //Digital Output
    DigitalOut LED_Blue1(PC_10);
    DigitalOut LED_Blue2(PC_11);
    DigitalOut LED_Red1(PC_12);
    DigitalOut LED_Red2(PD_2);
#endif

#endif // CONFIGURATION_H_
//-----------------------------------------------------------------