/*
* Los Putacos
* Copyright (C) 2017, All rights reserved.
* ________________________________________ 
*
* Created by: Gustavo Campana, Michael Schmidt, Miguel Lopez
*       Date: 12-Oct-2017
*    Version: V0.1
*/
//-----------------------------------------------------------------

//-----------------------------------------------------------------
#include "mbed.h"
#include "MPU9250.h"
//-----------------------------------------------------------------

//-----------------------------------------------------------------
#ifndef EVENT_H_
#define EVENT_H_
#define BufferSize 20000
#define BufferSize_MIC 5000
#define SampleRate 500             // Define Sample Rate in Hz

// Declarations
extern Serial PC;
extern Timer TimeStamp;
extern mpu9250_spi imu;
extern TCPSocket Socket_TCP;
extern nsapi_error_t response;

// Battery Voltage & Power Consumption Declaration
extern float Battery_Status;
extern float Power_Consumption;

// Analog Microphone/Current/Voltage Inputs
extern AnalogIn VSense;
extern AnalogIn ISense;
extern AnalogIn Micro_1;
extern AnalogIn Micro_2;

// Buzzer PWM Output
extern PwmOut Buzzer;

// Digital LED Outputs
extern DigitalOut LED_Blue1;
extern DigitalOut LED_Blue2;
extern DigitalOut LED_Red1;
extern DigitalOut LED_Red2;

// Writepointers
extern volatile uint16_t writePointer;
extern volatile uint16_t writePointer_MIC;

// Data Storage Buffers
extern char Time_Buffer[2];
extern char Data_Buffer[1024];
extern const char DeviceNr[6];
extern int16_t Data_Storage[BufferSize];
extern uint16_t Data_Storage_MIC[BufferSize_MIC];

// Flag Declaration
extern uint8_t ReadIMUDone_Flag;
extern uint8_t CheckCommandDone_Flag;

// Time Buffer Declaration
extern uint16_t Time_Data;
extern uint8_t Requested_Time;

// EventQueue Declaration
extern EventQueue queue;

// Thread Declaration
extern Thread Thread_IMU;
extern Thread Thread_ReadBattery;
extern Thread Thread_ReceiveCommand;

// Ticker Declaration
extern Ticker Ticker_IMU;
extern Ticker Ticker_ReadBattery;
extern Ticker Ticker_ReceiveCommand;

// Function Declarations
void ReadIMU(void);
void ReadBattery(void);
void ReceiveCommand(void);

#endif // EVENT_H_
//-----------------------------------------------------------------

//-----------------------------------------------------------------