
#ifndef MAIN_H
#define MAIN_H

//General Digital Outputs
#define MBED_DD_EN       P0_19
#define MBED_OSC_EN      P0_20
#define MBED_AMP1_EN     P2_8
#define MBED_AMP2_EN     P2_9

#define MBED_ATT_A       P2_5
#define MBED_ATT_B       P2_4
#define MBED_ATT_C       P2_3

#define MBED_ATT_D       P2_2
#define MBED_ATT_E       P2_1

#define MBED_LED1        P1_18
#define MBED_LED2        P1_20
#define MBED_LED3        P1_21

#define MBED_SW1         P0_22
#define MBED_MSW1        P4_29
#define MBED_MSW2        P4_28

//SPI for LMX2594
#define MBED_CSB_LMX     p8
#define MBED_CLK_LMX     p7
#define MBED_MOSI_LMX    p5
#define MBED_MUX_SYNTH   p6 //MISO

//SPI for EEPROM
/*
#define MBED_CS_EEP      P0_6
#define MBED_CLK_EEP     P0_7
#define MBED_MISO_EEP    P0_9
#define MBED_MOSI_EEP    P0_8
*/
//SPI for LMX2594
//#define MBED_CSB_LMX     P2_11
//#define MBED_CLK_LMX     P2_13
//#define MBED_MOSI_LMX    P2_12
//#define MBED_MUX_SYNTH   P0_17 //MISO

//ADC Inputs 
#define MBED_TEMP_LMX         P0_23
#define MBED_PEAK_DET_IN      P0_24

//Serial Inputs and Outputs
#define MBED_SBUS_RX          P0_1
#define MBED_SBUS_TX          P0_0

#define MBED_REG_TX           P0_15

//DAC Output
#define MBED_DAC         P0_26

//LMX Debug IO
#define MBED_RDIR_SYNTH  P2_6
#define MBED_RCLK_SYNTH  P2_7


//Global defines
#define SPI_CLK_SPEED 1

#define DEBUG 1


//Function declarations
void LMX2594_Read_All_Registers(void);
void Startup_Splash(void);
void LMX2594_Spi_Write(char address, unsigned short data);
int LMX2594_Spi_Read(char address);
/*
//SPI for EEPROM
DigitalOut CS_EEP(MBED_CS_EEP);
DigitalOut CLK_EEP(MBED_CLK_EEP);
DigitalIn MISO_EEP(MBED_MISO_EEP);
DigitalOut MOSI_EEP(MBED_MOSI_EEP);
*/


#endif


