#include "ble/BLE.h"

class PosService {
public:
    typedef uint8_t  dist_t[3];
    ReadOnlyGattCharacteristic<dist_t> distanceCharacteristic;
    
        PosService(BLE& _ble) :
            ble(_ble),
            distanceCharacteristic(0x2A59, &pos) 
        {            
            GattCharacteristic *charTable[] = { &distanceCharacteristic };
            GattService posService(0x2601, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
            ble.gattServer().addService(posService);
        }
        
    void updatePos(dist_t poss) {
        
        //ble.gattServer().write(distanceCharacteristic.getValueHandle(), &poss, 1);
    }
private:
    BLE& ble;
    
    dist_t pos;
};