

#include "mbed.h"
#include "BLE.h"
#include "BatteryService.h"
#include "LocatorService.h"


BLE ble;


const static char DEVICE_NAME[] = "Locator RedBear";

static const uint16_t serviceList[] = {
    0x1821 
};

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    /* Restart Advertising on disconnection*/
    ble.gap().startAdvertising();
}


int main(void)
{
    printf("Starting locator\n");
    
    ble.init();
    ble.gap().onDisconnection(disconnectionCallback);

    /* Setup weather service. */
    LocatorService locatorService(ble);
+
    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)serviceList, sizeof(serviceList));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(100); /* 1000ms */
    ble.gap().startAdvertising();
         
    while (true) {            
        ble.waitForEvent();
    }
}
