#include "ble/BLE.h"

class LampService {
public:
    typedef uint8_t  LightLevel_t;
    WriteOnlyGattCharacteristic<LightLevel_t> lightLevelCharacteristic;
    
        LampService(BLE& _ble) :
            ble(_ble),
            lightLevelCharacteristic(0x2A58, &lightLevel) 
        {            
            GattCharacteristic *charTable[] = { &lightLevelCharacteristic };
            GattService lampService(0x2600, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
            ble.gattServer().addService(lampService);
        }
private:
    BLE& ble;
    
    LightLevel_t lightLevel;
};