#include "mbed.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

InterruptIn mybutton(USER_BUTTON);

double tempo = 0.3; // LED blinking delay

// Change LEDs blinking frequency
void change_blinking_frequency() {
    if (tempo == 0.3) // If leds have low frequency
        tempo = 0.1;  // Set the fast frequency
    else              // If leds have fast frequency
        tempo = 0.3;  // Set the low frequency
}

int main() {
    // All LEDs are OFF
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;

    // Change LEDs blinking frequency when button is pressed
    mybutton.fall(&change_blinking_frequency);

    while(1) {
        myled2 = 1;   // LED2 is ON
        wait(tempo);  // wait tempo
        myled2 = 0;   // LED2 is OFF
        myled1 = 1;   // LED1 is ON
        wait(tempo);  // wait tempo
        myled1 = 0;   // LED1 is OFF
        myled3 = 1;   // LED3 is ON
        wait(tempo);  // wait tempo
        myled3 = 0;   // LED3 is OFF
        myled4 = 1;   // LED4 is ON
        wait(tempo);  // wait tempo
        myled4 = 0;   // LED4 is OFF
    }
}
