#ifndef SX1509_H
#define SX1509_H

#include "mbed.h"

// DEFINES - SX1509 Configuration
// ====================================================
#define SX1509_FREQUENCY    400000
#define SX1509_ADDR         (0x3E<<1)

// DEFINES - Register Addresses
// ====================================================
#define REGINPUTDISABLEB    (0x00)
#define REGINPUTDISABLEA    (0x01)
#define REGLONGSLEWB        (0x02)
#define REGLONGSLEWA        (0x03)
#define REGLOWDRIVEB        (0x04)
#define REGLOWDRIVEA        (0x05)
#define REGPULLUPB          (0x06)
#define REGPULLUPA          (0x07)
#define REGPULLDOWNB        (0x08)
#define REGPULLDOWNA        (0x09)
#define REGOPENDRAINB       (0x0A)
#define REGOPENDRAINA       (0x0B)
#define REGPOLARITYB        (0x0C)
#define REGPOLARITYA        (0x0D)
#define REGDIRB             (0x0E)
#define REGDIRA             (0x0F)
#define REGDATAB            (0x10)
#define REGDATAA            (0x11)
#define REGINTERRUPTMASKB   (0x12)
#define REGINTERRUPTMASKA   (0x13)
#define REGSENSEHIGHB       (0x14)
#define REGSENSELOWB        (0x15)
#define REGSENSEHIGHA       (0x16)
#define REGSENSELOWA        (0x17)
#define REGINTERRUPTSOURCEB (0x18)
#define REGINTERRUPTSOURCEA (0x19)
#define REGEVENTSTATUSB     (0x1A)
#define REGEVENTSTATUSA     (0x1B)
#define REGLEVELSHIFTER1    (0x1C)
#define REGLEVELSHIFTER2    (0x1D)
#define REGCLOCK            (0x1E)
#define REGMISC             (0x1F)
#define REGLEDDRIVERENABLEB (0x20)
#define REGLEDDRIVERENABLEA (0x21)
// Debounce
#define REGDEBOUNCECONFIG   (0x22)
#define REGDEBOUNCEENABLEB  (0x23)
#define REGDEBOUNCEENABLEA  (0x24)
#define REGKEYCONFIG1       (0x25)
#define REGKEYCONFIG2       (0x26)
#define REGKEYDATA1         (0x27)
#define REGKEYDATA2         (0x28)
// LED Driver
#define REGTON0             (0x29)
#define REGION0             (0x2A)
#define REGOFF0             (0x2B)
#define REGTON1             (0x2C)
#define REGION1             (0x2D)
#define REGOFF1             (0x2E)
#define REGTON2             (0x2F)
#define REGION2             (0x30)
#define REGOFF2             (0x31)
#define REGTON3             (0x32)
#define REGION3             (0x33)
#define REGOFF3             (0x34)
#define REGTON4             (0x35)
#define REGION4             (0x36)
#define REGOFF4             (0x37)
#define REGTRISE4           (0x38)
#define REGTFALL4           (0x39)
#define REGTON5             (0x3A)
#define REGION5             (0x3B)
#define REGOFF5             (0x3C)
#define REGTRISE5           (0x3D)
#define REGTFALL5           (0x3E)
#define REGTON6             (0x3F)
#define REGION6             (0x40)
#define REGOFF6             (0x41)
#define REGTRISE6           (0x42)
#define REGTFALL6           (0x43)
#define REGTON7             (0x44)
#define REGION7             (0x45)
#define REGOFF7             (0x46)
#define REGTRISE7           (0x47)
#define REGTFALL7           (0x48)
#define REGTON8             (0x49)
#define REGION8             (0x4A)
#define REGOFF8             (0x4B)
#define REGTON9             (0x4C)
#define REGION9             (0x4D)
#define REGOFF9             (0x4E)
#define REGTON10            (0x4F)
#define REGION10            (0x50)
#define REGOFF10            (0x51)
#define REGTON11            (0x52)
#define REGION11            (0x53)
#define REGOFF11            (0x54)
#define REGTON12            (0x55)
#define REGION12            (0x56)
#define REGOFF12            (0x57)
#define REGTRISE12          (0x58)
#define REGTFALL12          (0x59)
#define REGTON13            (0x5A)
#define REGION13            (0x5B)
#define REGOFF13            (0x5C)
#define REGTRISE13          (0x5D)
#define REGTFALL13          (0x5E)
#define REGTON14            (0x5F)
#define REGION14            (0x60)
#define REGOFF14            (0x61)
#define REGTRISE14          (0x62)
#define REGTFALL14          (0x63)
#define REGTON15            (0x64)
#define REGION15            (0x65)
#define REGOFF15            (0x66)
#define REGTRISE15          (0x67)
#define REGTFALL15          (0x68)
// Misc
#define REGHIGHINPUTB       (0x69)
#define REGHIGHINPUTA       (0x6A)
// Software Reset
#define REGRESET            (0x7D)
// Test Registers (do not write)
#define REGTEST1            (0x7E)
#define REGTEST2            (0x7F)

#define LINEAR 0
#define LOG 1

class SX1509{
    private:
        I2C i2c;
        uint8_t div_g;
        
        void i2cWrite8(char reg, char data);
        uint8_t i2cRead8(char reg);
        uint16_t i2cRead16(char reg);
           
    public:
        SX1509(PinName sda, PinName scl);
        
        enum mode_t {INPUT, OUTPUT, LED};
        
        bool init();
        void enableLEDDriver();
        void enableLEDDriver(uint8_t div, bool mode);
        void setLEDMode(bool mode);
        void setMode(uint8_t pin, mode_t mode);
        void setBreath(uint8_t pin, uint8_t fadeIn, uint8_t fadeOut);
        void setBlink(uint8_t pin, uint8_t tOn, uint8_t tOff, uint8_t iOff);
        void writePin(uint8_t pin, uint8_t intensity);
        void setReset();
        void fullReset();
};


#endif