//Main program for the ultrasonic firmware.
//Created by Eric Lindholm on 7 December 2015

//includes the mbed firmware and additional objects
#include "mbed.h"
#include "TDC1000.h"
#include "TDC7200.h"

/*
*   The current setup has the following pin-out
*   5           MOSI  to TDC1000
*   6           MISO  to TDC1000
*   7           SCLK  to TDC1000
*   8           SPICS to TDC1000
*   10          RST   to TDC1000
*   11          MOSI  to TDC7200
*   12          MISO  to TDC7200
*   13          SCLK  to TDC7200
*   14          SPICS to TDC7200
*   16          EN    to TDC1000
*   22          ChSel to TDC1000
*   23          ERR   to TDC1000
*   29          EN    to TDC7200
*   30          INT   to TDC7200
*       EN = Enable
*       SPICS = SPI chip select
*       RST = Reset
*       ChSel = Channel Selection
*       ERR = Error flag pin
*       INT = Interrupt flag pin
*       The TDC1000 is an ultrasonic driver/detector.
*       The TDC7200 is a stopwatch chip for very fine time samples.
*/

//For debugging
Serial pc(USBTX, USBRX);

//File-system and related function variable.
LocalFileSystem local("local");
char* input_data;

//Instantiate TDC1000 class
TDC1000 ultrasonic(p22,p23,p16,p10,p7,p8,p5,p6);

//Instantiate TDC7200 class
TDC7200 stopwatch(p29,p30,p12,p11,p13,p14);

//Function for settings
void go_to_settings(void);

int externalClockFrequency = 16000000;  //in Hz
double speedSoundWater = 1447;      //in m/s
double distanceBetweenTransducers = 0.02;       //2cm

//The start of the show.
int main() {
    //Set the time to the current time.
    //Right now, though, it just sets to August 26, 2015
    set_time(1440603500);
    
    //Set stuff up for fluid flow measurement
    ultrasonic.setMODE_SELECT(2);
    ultrasonic.setClockFrequencyIn(externalClockFrequency);
    stopwatch.setMODE_SELECT(1);
    stopwatch.setClockFrequencyIn(externalClockFrequency);
    
    //more setup
    ultrasonic.setTX_FREQ_DIV(0x03);
    if(!ultrasonic.readToggle(CH_SWP))
        ultrasonic.setToggle(CH_SWP);
    if(!ultrasonic.readToggle(EXT_CHSEL))
        ultrasonic.setToggle(EXT_CHSEL);
    if(ultrasonic.readToggle(TEMP_MODE))
        ultrasonic.setToggle(TEMP_MODE);
    if(ultrasonic.readToggle(FORCE_SHORT_TOF))
        ultrasonic.setToggle(FORCE_SHORT_TOF);
    double tof1;
    
    //Self check: currently empty
    
    //Attempt communication with a host
    pc.printf("\rBegin communications...\n");
    
    //If the host is reachable, synchronize data and stuff
    
    //If the host is unreachable, store data internally and check for contact every 5 minutes.
    //When contact is eventually made, dump data & start synchronizing
    
    //During synchronization:
    while(1) {
        //Query user
        pc.printf("\n\rPress 't' to trigger a new time-of-flight measurement, or press 's' for settings.\n");
        char userReply;
        userReply = pc.getc();
        if(userReply == 't') {
            //Tell the TDC7200 to trigger a start
            stopwatch.startMeasurement();
            //wait for a new measurement to be completed.
            wait_us(20);
            tof1 = stopwatch.readTimeOfFlight(0);
        }
        else if(userReply == 's')
            go_to_settings();
        else if(userReply == 'f')
            stopwatch.forceMeasurementRead();
        
        //wait for the 5 or so cycles to complete and be measured
        
        //Get the time of flight from the TDC7200
        
        //Get the average time of flight from the 5 or so measurements
        
        //Put that data in internal memory for about 5 seconds
        //Synchronize with storage media and/or host approx. every 5 seconds.
        pc.printf("\n\rThe most recent time-of-flight was %X ", tof1);
        
        //Repeat several times per second
    }
        
    //If no host is known at all, perform first-time setup.
}

//settings function
void go_to_settings(void) {
    //List all the current settings
    
    //Ask if any changes need to be made
}