//Object file for SPI register action for a TI chip
//Created on 7 December 2015 by Eric Lindholm
//Member functions contained in TI_Registers.cpp

#include "mbed.h"

/** TI_Registers
 *   The TI_Registers class features an SPI connection to a TI chip.
 *   More documentation to come.
 */

#ifndef TI_REGISTERS_H
#define TI_REGISTERS_H

//Abstract data definitions
class TI_Registers 
{
public:
    /** Ultrasonic_Registers class
     *   To access the registers of the ultrasonic driver chip: the TDC1000
     *   MOSI is the pin which is assigned as serial out from the MCU.
     *   MISO is the pin which is assigned as serial in to the MCU.
     *   SCLK is the pin which is assigned as serial clock.
     *   SPICS is the chip select pin for the SPI connection.
     */
    TI_Registers(PinName MOSI, PinName MISO, PinName SCLK, PinName SPICS);
 
    /** registerRead8 function
     *   The registerRead functions individually read 1, 2, or 3 bytes of data.
     *   address is the address that is included in the TI documentation for the 
     *    register in question, and is 6 bits long.
     */
    int registerRead8(int);
     
    /** registerRead16 function
     *   The registerRead functions individually read 1, 2, or 3 bytes of data.
     *   address is the address that is included in the TI documentation for the 
     *    register in question, and is 6 bits long.
     */
    int registerRead16(int);
     
    /** registerRead24 function
     *   The registerRead functions individually read 1, 2, or 3 bytes of data.
     *   address is the address that is included in the TI documentation for the 
     *    register in question, and is 6 bits long.
     */
    int registerRead24(int);

    /** registerWrite function 
     *   The registerWrite function writes one byte of data to the register 
     *   address is the 8-bit address for the register in question, determined
     *    from the TI documentation for the chip: 6 bits.  
     *   contents is the 8 bits of data that will be written to the register.
     */
    void registerWrite(int, int);
private:
    SPI device;
    DigitalOut cs;
};

#endif