#include "mbed.h"
#include "RawSerial.h"
#include "string.h"
#include "stdio.h"

//setup the other wifi pins
DigitalOut rstPin (PTE29);
DigitalOut chpdPin (PTE23);


RawSerial esp (PTC4, PTC3, 115200); //setup a serial to the  (board) Tx = PTC4 and  Rx = PTC3 pins at baud rate 115200

Serial pc(USBTX, USBRX, 115200);

DigitalOut redLED(LED1); // twp leds
DigitalOut greenLED(LED2); // to allow visual check of bidirectional comms
DigitalOut blueLED(LED3);  //to prove it's working

char input; //character to store inputs/outputs in communication

//char * getRequest = "GET / HTTP/1.1\r\nHost: time.jsontest.com\r\nConnection: keep-alive\r\nCache-Control: max-age=0\r\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\nUser-Agent: Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\r\nAccept-Encoding: gzip,deflate,sdch\r\nAccept-Language: en-US,en;q=0.8";
//char * getRequest = "GET / HTTP/1.1\r\nHost: time.jsontest.com\r\n\r\n";
//char buf[20];
//sprintf(buf, "AT+CIPSEND=1,%d", sizeof(getRequest));

char* startCommands[5]= {
    "AT+RST",
    "AT+CWMODE=1",
    "AT+CWJAP=\"Hotspot\",\"password\"", skip signing in for debugging purposes
    "AT+CIPMUX=1",
    "AT+CIPSTART=1,\"TCP\",\"time.jsontest.com\",80" //time.jsontest.com
};


void sendCommand(char* command, int commandNumber)
{
    pc.printf("\r\ncommand %d",commandNumber);  //identify the command number
    pc.printf("\r\n");

    esp.printf("%s\r\n",command);    //send command

}


void getTime()
{
    int * timeDate [2]; //stores time and date

    pc.printf("Syncing time with internet\r\n");
    char *msg=(char *)malloc(50);
    char *msg2= "GET / HTTP/1.1\r\nhost: time.jsontest.com\r\n\r\n";

    sprintf(msg,"AT+CIPSEND=1,%d",strlen(msg2));

    pc.printf("%s\r\n",msg);
    esp.printf("%s\r\n",msg);
    pc.printf("%s\r\n",msg2);
    esp.printf("%s\r\n",msg2);
    
    

}
char * buffer [128];
char * nextBuff;


int k = 0; //counter for comm numb




void start()
{
    pc.printf("Initialising start sequence\r\n");

    int numberOfCommands = sizeof(startCommands)/sizeof(startCommands[0]); // check if this works
    for (int i = 0; i<numberOfCommands; i++) {

        sendCommand(startCommands[i],i);
        wait (6); //wait an arbitrary time between each command

    }
}

void reset()     //resets the module by turning rst off for 2 seconds then on again
{
    rstPin = 0;
    wait(2);
    rstPin = 1;
    pc.printf("Reset complete\r\n");

}

void esp_recv()
{
    redLED = !redLED;
    while(esp.readable()) {
        pc.putc(esp.getc());
    }
}


void pc_recv()
{
    char c;
    greenLED = !greenLED;
    while(pc.readable()) {
        c=pc.getc();
        esp.putc(c);

        /*
        /////////////////////////////////////////////////////////////////////////////////////this section is for debugging purposes only remove when done
                if(c=='x') {
                    pc.printf("\r\ncommand %d",k);  //identify the command number
                    pc.printf("\r\n");

                    esp.printf("%s\r\n",startCommands[k]);    //send command
                    pc.putc(10); //ie makes enter perform as expected

                    if (k <10) {
                        k++;   //reset k if required
                    } else {
                        k=0;
                    }
                }
        *////////////////////////////////////////////////////////////////////////////////////

        if(c==13) {
            pc.putc(10); //ie makes enter perform as expected
            esp.putc(10);
        }
    }
}

void initiateWifi()
{

    //initialise the pins
    rstPin = 1;
    chpdPin = 1;

    reset();    //perform an initial reset

    blueLED = 1; //turn on test light

    pc.attach(&pc_recv, Serial::RxIrq); // attach the two interrupt services
    esp.attach(&esp_recv, Serial::RxIrq);

    wait(10);
    start();

    wait (3);
    getTime();
    /*
    pc.printf("%d",dateTime[0]);
    pc.printf("%d",dateTime[1]);
    */
}
