
#include "mbed.h"
#include "TextLCD.h"
 
// Host PC Communication channels

Serial pc(USBTX, USBRX); // tx, rx

// LCD instantiation

TextLCD lcd(PTC7, PTC0, PTD4, PTA12, PTC5, PTC6);        // 4bit bus: rs, e, d4-d7
    
int main() {
    
// Initialise sample date and time

    int time = 1234;
    int date = 220517;

// Adjust format of time to reflect hours and minutes

    int hours = time/100;
    int minutes = time - hours*100;

// Adjust format of date to reflect days and minutes

    int day = date/10000;
    int month = (date - day*10000)/100;
    int year = date - month*100 - day*10000;

// Print correctly spaced values on the display

    lcd.printf("Time %d:%d", hours, minutes);
    
// Locate cursor to start of second line
    
    lcd.setAddress(0, 1);
    
    lcd.printf("Date %d/%d/%d", day, month, year);

}    

