
#include "mbed.h"
#include "TextLCD.h"
#include "stdio.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial28x28.h"
#include "Arial24x23.h"
#include "Arial12x12.h"

 
// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx

// LCD instantiation 
TextLCD lcd(PTC7, PTC0, PTD4, PTA12, PTC5, PTC6);        // 4bit bus: rs, e, d4-d7

// the display has a backlight switch on board
DigitalOut LCD_LED(PTA13);   
DigitalOut pwr(PTD7); 

// the TFT is connected to SPI pin 5-7
//SPI_TFT_ILI9341 TFT(p5, p6, p7, p8, p9, p10,"TFT"); // mosi, miso, sclk, cs, reset, dc for lpc1768
SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1, PTD5, PTD0, PTA13,"TFT"); // mosi, miso, sclk, cs, reset, dc for frdmkl25z

//void updateDisplay(int time, int date, int temp) {
    
int main() { // Main program

int time = 1234;
int date = 220517;
int temp = 27;
int weather = 2; // 0 - Rain, 1 - Cloud, 2 - Sun

// Adjust format of time to reflect hours and minutes
int hours = time/100;
int minutes = time - hours*100;

// Adjust format of date to reflect days and minutes
int day = date/10000;
int month = (date - day*10000)/100;
int year = date - month*100 - day*10000;

// Print correctly spaced values on the display

    lcd.printf("Time %d:%d", hours, minutes);
    
    // Locate cursor to start of second line
    
    lcd.setAddress(0, 1);
    
    lcd.printf("Date %d/%d/%d", day, month, year);

// Control for the touch screen display
   
    pwr=1; // Power On

    LCD_LED = 1;            // Backlight on

    TFT.claim(stdout);        // Send stdout to the TFT display
    TFT.set_orientation(1);   // Orients screen to wipe in the horizontal direction
    TFT.background(Black);    // Sets background to black
    TFT.foreground(White);    // Sets text to white
    TFT.cls();                // Clear the screen
    
    TFT.set_orientation(0);     // Ensures orientation vertical 0 degrees
    TFT.background(Black);      // Sets background to black
    TFT.cls();                  // Clear the screen
    
    TFT.set_font((unsigned char*) Arial24x23);      // Select header font
    TFT.locate(10, 180);                            // x,y - locates cursor
    TFT.printf("Oxford");                           // Print Oxford 

    TFT.set_font((unsigned char*) Arial28x28);      // Select header font
    TFT.locate(10,220);                             // x,y - locates cursor
    TFT.printf("%dC", temp);                        // Print temperature data
    
// Print weather dependant images on the touch screen

    switch(weather) { // Decides which weather state to print based on the web update
        
        case 0: // Rain
        
            TFT.fillcircle(115,78,20,DarkGrey); // An image of the rain, stored on the board and loaded if weather = 0 
            TFT.fillcircle(130,60,15,DarkGrey);
            TFT.fillcircle(160,55,30,DarkGrey);
            TFT.fillcircle(190,60,15,DarkGrey);
            TFT.fillcircle(205,75,20,DarkGrey);
            TFT.fillcircle(158,75,22,DarkGrey);
            TFT.fillcircle(130,75,20,DarkGrey);
            TFT.fillcircle(185,80,15,DarkGrey);
            
            TFT.line(110,100,110,130,Blue);
            TFT.line(134,102,134,136,Blue);
            TFT.line(158,101,158,139,Blue);
            TFT.line(182,102,182,136,Blue);
            TFT.line(206,100,206,130,Blue);
            
            break;
        
        case 1: // Cloud
    
            TFT.fillcircle(115,78,20,White); // An image of a cloud, stored on the board and loaded if weather = 1
            TFT.fillcircle(130,60,15,White);
            TFT.fillcircle(160,55,30,White);
            TFT.fillcircle(190,60,15,White);
            TFT.fillcircle(205,75,20,White);
            TFT.fillcircle(158,75,22,White);
            TFT.fillcircle(130,75,20,White);
            TFT.fillcircle(185,80,15,White);
            
            break;
    
        case 2: // Sun
        
            TFT.fillcircle(170,80,40,Yellow); // An image of the sun, stored on the board and loaded if weather = 2
            
            break;
            
            }
            
}
