#include  "mbed.h"
#include "ADXL362.h"

Serial pc(USBTX, USBRX); //Creates object for serial device
ADXL362 adxl362(p11, p12, p13, p10); //Creates object for ADXL362

  int8_t xdata = 0; // accelerometer data raw (8 bit)
  int8_t ydata = 0;
  int8_t zdata = 0;
  int N = 10;
  int choice=0; 
  int i, exit_flag=0;
  float tdata;
  float T=0.05;
  
int main()
{
  adxl362.init_spi();//spi interface initiated//
  adxl362.init_adxl362(); //Accelerometer initiated//
  wait(0.01);
  
while(1)
{ 
    pc.scanf("%d",&choice);

    if (choice==1)
    {
        wait(0.2); //allows 0.2s for accelerometer to initiate//
        for (i = 0; i < N; i = i++) //for loop runs N times//
        {
          adxl362.ACC_GetXYZ8(&xdata, &ydata, &zdata); //Retreives Data from accelerometer//
          tdata=T+(T*i);//calculates and stores time data in array//
          pc.printf("%d,%d,%d,%f\n", xdata, ydata, zdata, tdata); //prints x,y,z and t data//
          wait(T); //wait T seconds before next loop cycle
        } 
        
    }
    
    if (choice==2) //continuous data capture//
    while(exit_flag==0)
        {
            adxl362.ACC_GetXYZ8(&xdata, &ydata, &zdata); //Retreives Data from accelerometer//
             tdata=T+(T*i);//calculates and stores time data in array//
            pc.printf("%d,%d,%d,%f\n", xdata, ydata, zdata, tdata); //prints x,y,z and t data//
            wait(T); //wait T seconds before next loop cycle
        } 
    
    if (choice==3)
        {
            pc.scanf("%d", &N);
            wait(0.2);
        }
    
    if (choice==4)
        {
            pc.scanf("%f",&T);
            wait(0.2);
        }
}
}