#include "mbed.h"
#include "ultrasonic.h"

PwmOut TX1(D11);                             // Use pin D11
PwmOut TX2(D10);
//DigitalOut TX2(D10);                         // Use pin D10
DigitalOut HVoff(D12);                       // Use pin D12
InterruptIn signal(D13);                     // Use pin D13
Timeout to1;
Timer t1;
Serial pc(SERIAL_TX, SERIAL_RX);

float previous = 1;

void TX1_send(){
    
    previous = 1;
    HVoff = 0;
    TX1.period(0.0000252);                  // Set the period of TX1 to 25.2us (39,682kHz)
    TX1.pulsewidth(0.0000116);              // Set the pulsewidth of TX1 to 11.6us (ON)
    wait(0.0000058);
    TX2.period(0.0000252);
    TX2.pulsewidth(0.0000116);
    wait(0.000300);                         // Waits 201.6us
    TX1 = 0;
    TX2 = 0;
    t1.reset();
    HVoff = 1;
    to1.attach(TX1_send,0.1);               // Sends for 1000us
    }


void signal_reciev(){
   float _time = t1.read();
    if (_time<0.006 && _time>0.00057){       // Reads only between 100cm and 1,7cm
    
    if (t1.read()>previous){
        pc.printf("check");
        }
    
    else{
        
        previous = _time;
        
        float cm = 0;
    
        
            cm = 34613*_time/2;                  // Calculate distance
            pc.printf("%f\r\n", cm);             // Prints distance
        }
        }
    }

int main() {
     
    t1.start();
    signal.fall(&signal_reciev);
    //TX2 = 0;
    TX1_send(); 
    while(1);
    }