#include "mbed.h"
#include "ultrasonic.h"

digitalIn Signal(D12);
digitalIn Trig();
digitalIn Echo();

digitalOut Threshold(D13);
digitalOut HVOff(D11);
digitalOut Tx1(D10);
digitalOut Tx2(D9);

 void dist(int distance)
{
    //put code here to happen when the distance is changed
    printf("Distance changed to %dmm\r\n", distance);
}

ultrasonic mu(D8, D9, .1, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes

int main()
{
    mu.startUpdates();//start mesuring the distance
    while(1)
    {
        //Do something else here
        mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
    }
}
