#include "mbed.h"
#include "C12832.h"
#include "HCSR04.h"
/*
    Written by Leong Kum Loong.
    04 Dec 2017, REV. 0
    
    When HCSR04.h reference is included, DO NOT declare pin p21 & p22 as it is used by my library.
*/

C12832 lcd(p5, p7, p6, p8, p11);
DigitalOut led(LED1);
InterruptIn joyCtr(p14);

int unit = 1;
char str[] = "Distance: %.2f cm        ";

void config() {
    if(unit == 1){
        unit = 2;
        strcpy(str, "Distance: %.3f inch        ");
    } else {
        unit = 1;
        strcpy(str, "Distance: %.2f cm        ");
    }
    getDistance(unit);  //Unit 1 for CM & 2 for INCH
}

int main() {
    joyCtr.rise(config);
    getDistance();  //Start retrieving distance.
    lcd.cls();
    
    while(1) {
        lcd.locate(0,1);
        lcd.printf(str, readDistance());    //Read retrieved distance.
        
        led = !led;
        wait_ms(100);   //**** Wait function will cause delay to the ultrasonic sensor next read cycle.
    }
}