#include "mbed.h"
#include "tone.h"
#include "C12832.h"

/*
    Written by Leong Kum Loong.
    20 Nov 2017, REV. 2
    
    When tone.h reference is included, DO NOT declare pin p26 as it is used by my library.
*/

C12832 lcd(p5, p7, p6, p8, p11);
DigitalIn up(p15), down(p12), left(p13), right(p16), ctr(p14);

int frequency = 500;    //Preset tone frequency.

void writeMenu(){
    lcd.cls();
    lcd.locate(0,1);
    lcd.printf("UP/DOWN for example.");
    lcd.locate(0,12);
    lcd.printf("LEFT/RIGHT set frequency.");
    lcd.locate(0,22);
    lcd.printf("BUTTON to PLAY/STOP.");
}

void writeFreq(){
    lcd.cls();
    lcd.locate(0,1);
    lcd.printf("Frequency: %dHz", frequency);
}

int main() {
    writeMenu();
    int play;
    
    while(1) {
        if(up){
            mario_example();
        }else if(down){
            starwars_example();    
        }else if(left){
            int i=0;
            do{
                while(left){
                    if(frequency > 0)frequency-=100;
                    wait_ms(100);
                    writeFreq();
                }
                wait_ms(300);
                while(i<20){
                    if(left){
                        break;
                    }else if(right){
                        i=20;
                        break;
                    }
                    wait_ms(100);
                    i++;
                }
            } while(i<20);
            writeMenu();
        }else if(right){
            int i=0;
            do{
                while(right){
                    if(frequency < 20000)frequency+=100;
                    wait_ms(100);
                    writeFreq();
                }
                wait_ms(300);
                while(i<20){
                    if(right){
                        break;
                    }else if(left){
                        i=20;
                        break;
                    }
                    wait_ms(100);
                    i++;
                }
            }while(i<20);
            writeMenu();
        }else if(ctr){
            while(ctr);
            wait_ms(300);
            play=!play;
            if(play){
                tone(frequency);
            }else{
                noTone();
            }
        }
    }
}