/*
 * IniParser.h
 *
 *  Created on: 5 sept. 2017
 *      Author: christophe.sagnes
 */

#ifndef INIPARSER_H_
#define INIPARSER_H_

#include <fstream>
#include <sstream>
#include <string>
#include <map>
#include <iostream>
#include "mbed.h"

class INIParser {

 private:
    std::map<std::string, std::map<std::string, std::string> > ini;
    std::string FileName;
    bool AutoSave;

public:
    INIParser(const std::string &, bool=false);
    virtual ~INIParser();

     // permet de recupérer une valeur, et retourne une valeur par defaut si la clef n'est pas trouvée
     template <class T> T GetValue(const std::string &, const std::string &, const T &);
     // permet d'enregistrer une valeur, ou d'en modifier une existante.
     template <class T> void SetValue(const std::string &, const std::string &, const T &);
     // enregistre la map dans un fichier.
     bool save(std::string="");
     
     // permet de recupérer un entier, et retourne une valeur par defaut si la clef n'est pas trouvée
     int GetInt(const std::string &, const std::string &, const int &);

};

#endif /* INIFILE_H_ */
