/*
 * INIParser.cpp
 *
 *  Created on: 5 sept. 2017
 *      Author: christophe.sagnes
 */

#include "IniParser.h"

LocalFileSystem local("local") ;

INIParser::~INIParser() {
    // TODO Auto-generated destructor stub
     if(AutoSave)    save();
     ini.clear();
}

// spécialisation de la fonction pour la class std::string
template <> std::string INIParser::GetValue<std::string>(const std::string &Section, const std::string &clef, const std::string &defaultValue)
{
    std::map<std::string, std::map<std::string, std::string> >::iterator _it=ini.find(Section);

    if(_it != ini.end())
    {
        std::map<std::string, std::string>::iterator it=_it->second.find(clef);

        if(it != _it->second.end())
            return it->second;
        else
            return defaultValue;
    }
    else
        return defaultValue;
}


template <class T> T INIParser::GetValue(const std::string &Section, const std::string &clef, const T &defaultValue)
{
    std::map<std::string, std::map<std::string, std::string> >::iterator section_it=ini.find(Section);

    if(section_it != ini.end())    // si la valeur Section n'est pas trouvé
    {
        std::map<std::string, std::string>::iterator param_it=section_it->second.find(clef);

        if(param_it != section_it->second.end())  // si la valeur clef n'est pas trouvé
        {
            // permet la convertion de la valeur en type std::string dans le type demandé
            T val;
            std::istringstream iss(param_it->second);
            iss >> val;
            return val;
        }
        else
            return defaultValue;
    }
    else
        return defaultValue;
}

int INIParser::GetInt(const std::string &Section, const std::string &clef, const int &defaultValue)
{
    std::map<std::string, std::map<std::string, std::string> >::iterator section_it=ini.find(Section);

    if(section_it != ini.end())    // si la valeur Section n'est pas trouvé
    {
        std::map<std::string, std::string>::iterator param_it=section_it->second.find(clef);

        if(param_it != section_it->second.end())  // si la valeur clef n'est pas trouvé
        {
            // permet la convertion de la valeur en type std::string dans le type int
            int val;
            std::istringstream iss(param_it->second);
            iss >> val;
            return val;
        }
        else
            return defaultValue;
    }
    else
        return defaultValue;
}

template <class T> void INIParser::SetValue(const std::string &Section, const std::string &clef, const T &Value)
{
    std::ostringstream oss;
    // convertion de la valeur en std::string
    oss << Value;
    // enregistrement de la valeur dans la map
    ini[Section][clef] = oss.str();
}

INIParser::INIParser(const std::string &filename, bool autoSave)
{
    std::string section, line, clef, valeur;
    //size_t pos;
    int pos;

    AutoSave = autoSave;
    FileName = filename;

    //std::cout << "Debut" << std::endl ;

    std::ifstream file(filename.c_str());

    if (!file.good())
    {
        std::cout << "Pas de fichier " << std::endl ;
        return ;
    }


    while (!file.eof())
    {
        std::getline (file, line);

        // supression des commentaires
        pos = line.find_first_of(';');
        if(pos != std::string::npos)    line.erase (line.begin() + pos, line.end());

        // continue si la ligne n'est pas vide
        if(!line.empty())
        {
            // teste si la ligne correspond a une section
            pos = line.find_first_of('[');
            if(pos != std::string::npos)
            {
                line.erase(line.begin(), line.begin() + pos+1);
                line.erase(line.begin() + line.find_first_of (']'), line.end());
                section = line;
            }
            else    // sinon elle correspond a une clef
            {
                pos = line.find_first_of('=');
                // si le '=' a bien été trouvé
                if(pos != std::string::npos)
                {
                    clef = line.substr (0, pos);
                    valeur = line.substr (pos+1);

                    // permet la supression de tous les espaces dans la clef
                    while(std::string::npos != (pos = clef.find_first_of(' ')))
                        clef.erase(pos);

                    ini[section][clef] = valeur;
                }
            }
        }
    }
//std::cout << "fin de fichier" << std::endl ;

    file.close();
}

bool INIParser::save(std::string filename)
{
    std::map<std::string, std::map<std::string, std::string> >::iterator section_it;
    std::map<std::string, std::string>::iterator param_it;

    std::ofstream file;

    if(filename == "")
        file.open(FileName.c_str());
    else
        file.open(filename.c_str());

    if(!file.is_open()) return false;

    // ecriture de la map dans le fichier demandé
    for(section_it=ini.begin(); section_it!=ini.end(); ++section_it)
    {
        file << "[" << section_it->first << "]" << std::endl;

        for(param_it=section_it->second.begin(); param_it!=section_it->second.end(); ++param_it)
            file << param_it->first << "=" << param_it->second << std::endl;
    }

    file.close();
    return true;
}
