//***********************************************************************************/
//
//          Constantes Pont Bacalan
//
//************************************************************************************/
#ifndef _CONST_
#define _CONST_

typedef  char           U8 ;
typedef  short          S16 ;
typedef  unsigned short U16 ;
typedef  float          F32 ;
typedef  int            S32 ;

#ifndef TRUE
#define TRUE            1
#endif

#ifndef FALSE
#define FALSE           0
#endif

#define REG_INPUT_START             0
#define REG_INPUT_NREGS             260
#define SLAVE_ID                    0x01

#define EPSILON                     1E-9

#define ARRET                       0
#define MONTE                       1
#define DESCEND                     2

#define MODE_ARRET                  0
#define MODE_MANUEL                 1
#define MODE_AUTOMATIQUE            2
#define MODE_PARAMETRAGE            3
#define MODE_ETALONNAGE             4
#define MODE_ALIGNEMENT             5

#define AUCUN                       0
#define DEUX_VITESSES               1
#define RD_SUIT_RG                  2
#define RG_SUIT_RD                  3
#define CUSTOM                      4

#define TAILLE_TABLEAU_HAUTEURS     6

#define Version_Soft                Memoire_S16[1]

// Boutons
#define BTN_Arret                   Memoire_S16[120]
#define BTN_Monte                   Memoire_S16[121]
#define BTN_Descend                 Memoire_S16[122]
#define BTN_Etalonnage              Memoire_S16[140]


#define BTN_Monte_RD                Memoire_S16[125]
#define BTN_Descend_RD              Memoire_S16[126]

#define BTN_Monte_RG                Memoire_S16[130]
#define BTN_Descend_RG              Memoire_S16[131]


#define BTN_Frein                   Memoire_S16[141]
#define BTN_Aligne                  Memoire_S16[142]

//Temps de scrutation
#define Duree_Boucle_us             Memoire_S16[2]
#define Periode_Scrutation_ms       Memoire_S16[3]

//Modes de fonctionnement
#define Mode_Fonctionnement         Memoire_S16[15]
#define Mode_Synchro                Memoire_S16[16]

//Informations rive droite
#define Etat_RD                     Memoire_S16[20]
#define Hauteur_RD                  Memoire_S16[21]
#define Vitesse_RD                  Memoire_S16[22]
#define Couple_RD                   Memoire_S16[23]
#define Acceleration_RD             Memoire_S16[24]
#define Mesure_RD                   Memoire_S16[25]
#define Etat_COM_RD                 Memoire_S16[26]
#define Compteur_Timeout_RD         Memoire_S16[27]
#define Consigne_Vitesse_RD         Memoire_S16[28]
#define Consigne_Hauteur_RD         Memoire_S16[29]

#define Hauteur_RD1_mm              Memoire_S16[35]
#define Hauteur_RD2_mm              Memoire_S16[36]
#define Hauteur_RD1_pts             Memoire_S16[37]
#define Hauteur_RD2_pts             Memoire_S16[38]

//Informations rive gauche
#define Etat_RG                     Memoire_S16[40]
#define Hauteur_RG                  Memoire_S16[41]
#define Vitesse_RG                  Memoire_S16[42]
#define Couple_RG                   Memoire_S16[43]
#define Acceleration_RG             Memoire_S16[44]
#define Mesure_RG                   Memoire_S16[45]
#define Etat_COM_RG                 Memoire_S16[46]
#define Compteur_Timeout_RG         Memoire_S16[47]
#define Consigne_Vitesse_RG         Memoire_S16[48]
#define Consigne_Hauteur_RG         Memoire_S16[49]

#define Hauteur_RG1_mm              Memoire_S16[55]
#define Hauteur_RG2_mm              Memoire_S16[56]
#define Hauteur_RG1_pts             Memoire_S16[57]
#define Hauteur_RG2_pts             Memoire_S16[58]

//Informations pont
#define Etat_P                      Memoire_S16[60]
#define Hauteur_P                   Memoire_S16[61]
#define Vitesse_P                   Memoire_S16[62]
#define Couple_P                    Memoire_S16[63]
#define Acceleration_P              Memoire_S16[64]

#define Consigne_Vitesse_Manu       Memoire_S16[67]
#define Consigne_Vitesse_Auto       Memoire_S16[68]
#define Consigne_Haute_P            Memoire_S16[69]
#define Consigne_Basse_P            Memoire_S16[70]

#define Anticipation_Synchro        Memoire_S16[80]
#define KP_Synchro                  Memoire_S16[81]
#define KI_Synchro                  Memoire_S16[82]
#define KD_Synchro                  Memoire_S16[83]


#define Hauteur_mini                Memoire_S16[100]
#define Hauteur_maxi                Memoire_S16[101]
#define Vitesse_mini                Memoire_S16[102]
#define Vitesse_maxi                Memoire_S16[103]

#define Ecart_Synchronisation       Memoire_S16[110]
#define Defaut_Mineur_Synchro       Memoire_S16[111]
#define Defaut_Majeur_Synchro       Memoire_S16[112]
#define Defaut_Critique_Synchro     Memoire_S16[113]
#define Correction_Synchro          Memoire_S16[114]
#define Defaut_Critique_Manu_mm     Memoire_S16[115]

//Parametres variateur rive droite
#define Param_Version_RD            Memoire_S16[150]
#define Param_Startup_RD            Memoire_S16[151]
#define Param_Increment_RD          Memoire_S16[152]
#define Param_Seuil_Demarrage_RD    Memoire_S16[153]
#define Param_Acceleration_RD       Memoire_S16[154]
#define Param_Deceleration_RD       Memoire_S16[155]
#define Param_Kpv_RD                Memoire_S16[156]
#define Param_Kiv_RD                Memoire_S16[157]
#define Param_Kdv_RD                Memoire_S16[158]
#define Param_Kav_RD                Memoire_S16[159]
#define Param_Consigne_RD           Memoire_S16[160]

//Parametres variateur rive gauche
#define Param_Version_RG            Memoire_S16[200]
#define Param_Startup_RG            Memoire_S16[201]
#define Param_Increment_RG          Memoire_S16[202]
#define Param_Seuil_Demarrage_RG    Memoire_S16[203]
#define Param_Acceleration_RG       Memoire_S16[204]
#define Param_Deceleration_RG       Memoire_S16[205]
#define Param_Kpv_RG                Memoire_S16[206]
#define Param_Kiv_RG                Memoire_S16[207]
#define Param_Kdv_RG                Memoire_S16[208]
#define Param_Kav_RG                Memoire_S16[209]
#define Param_Consigne_RG           Memoire_S16[210]

//Commandes de sauvegarde mémoire
#define Sauver_Vers_Flash           Memoire_S16[245]

//Autres paramètres
#define Sauvegarde_automatique      Memoire_S16[246]
#define Etalonnage_effectue         Memoire_S16[247]
#define Etalonnage_en_cours         Memoire_S16[248]
#define RAZ                         Memoire_S16[249]
#define Mode_Debug                  Memoire_S16[250]


#endif

















