#include "mbed.h"
#include "tft.h"

#define TX_ID   (0x7e0)
#define RX_ID   (0x7e1)

DigitalOut led1(LED1);

CAN          can(PB_8, PB_9);  // CAN Rx pin name, CAN Tx pin name

char counter = 0;

#define NUMBER_TEXT_LINES   ( 23 )

int filterhandle=0, index =0;
char buffer[NUMBER_TEXT_LINES][200];
bool available = false;

/**
 * @brief   'CAN receive-complete' interrup handler.
 * @note    Called on arrival of new CAN message.
 *          Keep it as short as possible.
 * @param
 * @retval
 */
void onMsgReceived()
{
    CANMessage msg;

    memset ( &msg, 0, sizeof ( msg ) );

    if ( can.read ( msg ) ) {

        sprintf(buffer[index%NUMBER_TEXT_LINES],"0x%03x %d %02x %02x %02x %02x %02x %02x %02x %02x", msg.id,msg.len ,
                msg.data[0], msg.data[1], msg.data[2], msg.data[3], msg.data[4],msg.data[5], msg.data[6], msg.data[7]
               );

        available = true;
        index++;
    }
}

int main()
{
    int error;

    unsigned char q = 0;
    set_back(0);
    tft_init();

    tft_clear(TFT_BLUE);
    tft_set_window(32, 8, TFT_WIDTH + 32 - 1, TFT_HEIGHT + 8 - 1);

    set_back(1);

    CANMessage msg,txMsg;
restart:
    ;

    // can reset messes up the can (more init?)
    //can.reset();

    error = can.frequency(500000);                     // set bit rate to 1Mbps
    if(error == 0) {
        tft_text(0,0,"can.frequency",0xfff,0);
        wait(10);
        goto restart;
    }



    error = can.mode(CAN::Silent);
    if(error  == 0 ) {
        tft_text(0,0,"can.mode",0xfff,0);
        wait(10);
        goto restart;
    }

    //can.monitor(true);

  //  filterhandle = can.filter(0xff,0x07ff,CANAny,0);

    can.attach(&onMsgReceived);                 // attach 'CAN receive-complete' interrupt handler

    tft_clear(TFT_BLACK);

    tft_text(0,0," ID  LEN ------ Data  ------    Waiting",0xff0,0);

    while(1) {


#if 0
        char ind[ 12 ];

        memset ( &msg, 0, sizeof ( msg ) );

        error = can.read ( msg,0 ) ;

        if(error == 1) {
            sprintf(buffer[index%NUMBER_TEXT_LINES],"0x%03x %d %02x %02x %02x %02x %02x %02x %02x %02x", msg.id,msg.len ,
                    msg.data[0], msg.data[1], msg.data[2], msg.data[3], msg.data[4],msg.data[5], msg.data[6], msg.data[7]
                   );
            index++;
            index%=NUMBER_TEXT_LINES;
        }

        if( can.rderror() ) {

            tft_text(100,0,"can.rderror",0xfff,0);
            wait(1);
            tft_clear(TFT_BLACK);

            can.reset();
            can.frequency(500000);
            can.mode(CAN::Normal);
            q= 0;

        }

        sprintf(ind,"%03d %01d %d",index,error, can.rderror()  );

        tft_text(0,0,ind,0xfff,0);

#endif
        //for(unsigned char q=0;q< NUMBER_TEXT_LINES;q++)
        {
            tft_text(0,8+((q)*8),buffer[q],0xfff,0);

        }

        q++;
        q%=NUMBER_TEXT_LINES;

        led1 = !led1;
    }


}
