#include "mbed.h"
#include "LAS_TB.h"

Serial pc(USBTX, USBRX); // tx, rx

//initialize mp3 player.
LAS_TB LaserSensor(D1,D0);

DigitalOut TeKlein(D6);
DigitalOut Goed(D7);
DigitalOut TeGroot(D8);

double millimeters = 0;

int main()
{
    
    pc.baud(9600);
    
    pc.printf("Opstarten!\r\n");
    
    wait(1);
    
    while(1)
    {
        wait(2); //Om de 2 seconden uitvoeren.
        
        LaserSensor.MeasurementRequest();
        wait(0.5); //Halve sec wachten tot meting binnen is.
        
        //uitlezen.
        millimeters = (double)LaserSensor.umvalue/1000.0f; 
        
        pc.printf("millimeters: %f\r\n", millimeters);   
        
        if (millimeters < 49.95f)
        {
            TeKlein = true;
            Goed = false;
            TeGroot = false;
            pc.printf("Te klein!\r\n");   
        }
        else if (millimeters > 51.05f)
        {
            TeKlein = false;
            Goed = false;
            TeGroot = true;
            pc.printf("Te groot!\r\n");    
        }
        else
        {
            TeKlein = false;
            Goed = true;
            TeGroot = false;
            pc.printf("Goed!\r\n");    
        }
    }        
}
