/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_SPI_REGISTERS_H__
#define __HW_SPI_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 SPI
 *
 * Serial Peripheral Interface
 *
 * Registers defined in this header file:
 * - HW_SPI_MCR - Module Configuration Register
 * - HW_SPI_TCR - Transfer Count Register
 * - HW_SPI_CTARn - Clock and Transfer Attributes Register (In Master Mode)
 * - HW_SPI_CTARn_SLAVE - Clock and Transfer Attributes Register (In Slave Mode)
 * - HW_SPI_SR - Status Register
 * - HW_SPI_RSER - DMA/Interrupt Request Select and Enable Register
 * - HW_SPI_PUSHR - PUSH TX FIFO Register In Master Mode
 * - HW_SPI_PUSHR_SLAVE - PUSH TX FIFO Register In Slave Mode
 * - HW_SPI_POPR - POP RX FIFO Register
 * - HW_SPI_TXFRn - Transmit FIFO Registers
 * - HW_SPI_RXFRn - Receive FIFO Registers
 *
 * - hw_spi_t - Struct containing all module registers.
 */

#define HW_SPI_INSTANCE_COUNT (3U) /*!< Number of instances of the SPI module. */
#define HW_SPI0 (0U) /*!< Instance number for SPI0. */
#define HW_SPI1 (1U) /*!< Instance number for SPI1. */
#define HW_SPI2 (2U) /*!< Instance number for SPI2. */

/*******************************************************************************
 * HW_SPI_MCR - Module Configuration Register
 ******************************************************************************/

/*!
 * @brief HW_SPI_MCR - Module Configuration Register (RW)
 *
 * Reset value: 0x00004001U
 *
 * Contains bits to configure various attributes associated with the module
 * operations. The HALT and MDIS bits can be changed at any time, but the effect
 * takes place only on the next frame boundary. Only the HALT and MDIS bits in the
 * MCR can be changed, while the module is in the Running state.
 */
typedef union _hw_spi_mcr
{
    uint32_t U;
    struct _hw_spi_mcr_bitfields
    {
        uint32_t HALT : 1;             /*!< [0] Halt */
        uint32_t RESERVED0 : 7;        /*!< [7:1]  */
        uint32_t SMPL_PT : 2;          /*!< [9:8] Sample Point */
        uint32_t CLR_RXF : 1;          /*!< [10]  */
        uint32_t CLR_TXF : 1;          /*!< [11] Clear TX FIFO */
        uint32_t DIS_RXF : 1;          /*!< [12] Disable Receive FIFO */
        uint32_t DIS_TXF : 1;          /*!< [13] Disable Transmit FIFO */
        uint32_t MDIS : 1;             /*!< [14] Module Disable */
        uint32_t DOZE : 1;             /*!< [15] Doze Enable */
        uint32_t PCSIS : 6;            /*!< [21:16] Peripheral Chip Select x Inactive
                                        * State */
        uint32_t RESERVED1 : 2;        /*!< [23:22]  */
        uint32_t ROOE : 1;             /*!< [24] Receive FIFO Overflow Overwrite Enable */
        uint32_t PCSSE : 1;            /*!< [25] Peripheral Chip Select Strobe Enable */
        uint32_t MTFE : 1;             /*!< [26] Modified Timing Format Enable */
        uint32_t FRZ : 1;              /*!< [27] Freeze */
        uint32_t DCONF : 2;            /*!< [29:28] SPI Configuration. */
        uint32_t CONT_SCKE : 1;        /*!< [30] Continuous SCK Enable */
        uint32_t MSTR : 1;             /*!< [31] Master/Slave Mode Select */
    } B;
} hw_spi_mcr_t;

/*!
 * @name Constants and macros for entire SPI_MCR register
 */
/*@{*/
#define HW_SPI_MCR_ADDR(x)       ((x) + 0x0U)

#define HW_SPI_MCR(x)            (*(__IO hw_spi_mcr_t *) HW_SPI_MCR_ADDR(x))
#define HW_SPI_MCR_RD(x)         (HW_SPI_MCR(x).U)
#define HW_SPI_MCR_WR(x, v)      (HW_SPI_MCR(x).U = (v))
#define HW_SPI_MCR_SET(x, v)     (HW_SPI_MCR_WR(x, HW_SPI_MCR_RD(x) |  (v)))
#define HW_SPI_MCR_CLR(x, v)     (HW_SPI_MCR_WR(x, HW_SPI_MCR_RD(x) & ~(v)))
#define HW_SPI_MCR_TOG(x, v)     (HW_SPI_MCR_WR(x, HW_SPI_MCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SPI_MCR bitfields
 */

/*!
 * @name Register SPI_MCR, field HALT[0] (RW)
 *
 * The HALT bit starts and stops frame transfers. See Start and Stop of Module
 * transfers
 *
 * Values:
 * - 0 - Start transfers.
 * - 1 - Stop transfers.
 */
/*@{*/
#define BP_SPI_MCR_HALT      (0U)          /*!< Bit position for SPI_MCR_HALT. */
#define BM_SPI_MCR_HALT      (0x00000001U) /*!< Bit mask for SPI_MCR_HALT. */
#define BS_SPI_MCR_HALT      (1U)          /*!< Bit field size in bits for SPI_MCR_HALT. */

/*! @brief Read current value of the SPI_MCR_HALT field. */
#define BR_SPI_MCR_HALT(x)   (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_HALT))

/*! @brief Format value for bitfield SPI_MCR_HALT. */
#define BF_SPI_MCR_HALT(v)   ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_HALT) & BM_SPI_MCR_HALT)

/*! @brief Set the HALT field to a new value. */
#define BW_SPI_MCR_HALT(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_HALT) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field SMPL_PT[9:8] (RW)
 *
 * Controls when the module master samples SIN in Modified Transfer Format. This
 * field is valid only when CPHA bit in CTARn[CPHA] is 0.
 *
 * Values:
 * - 00 - 0 protocol clock cycles between SCK edge and SIN sample
 * - 01 - 1 protocol clock cycle between SCK edge and SIN sample
 * - 10 - 2 protocol clock cycles between SCK edge and SIN sample
 * - 11 - Reserved
 */
/*@{*/
#define BP_SPI_MCR_SMPL_PT   (8U)          /*!< Bit position for SPI_MCR_SMPL_PT. */
#define BM_SPI_MCR_SMPL_PT   (0x00000300U) /*!< Bit mask for SPI_MCR_SMPL_PT. */
#define BS_SPI_MCR_SMPL_PT   (2U)          /*!< Bit field size in bits for SPI_MCR_SMPL_PT. */

/*! @brief Read current value of the SPI_MCR_SMPL_PT field. */
#define BR_SPI_MCR_SMPL_PT(x) (HW_SPI_MCR(x).B.SMPL_PT)

/*! @brief Format value for bitfield SPI_MCR_SMPL_PT. */
#define BF_SPI_MCR_SMPL_PT(v) ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_SMPL_PT) & BM_SPI_MCR_SMPL_PT)

/*! @brief Set the SMPL_PT field to a new value. */
#define BW_SPI_MCR_SMPL_PT(x, v) (HW_SPI_MCR_WR(x, (HW_SPI_MCR_RD(x) & ~BM_SPI_MCR_SMPL_PT) | BF_SPI_MCR_SMPL_PT(v)))
/*@}*/

/*!
 * @name Register SPI_MCR, field CLR_RXF[10] (WORZ)
 *
 * Flushes the RX FIFO. Writing a 1 to CLR_RXF clears the RX Counter. The
 * CLR_RXF bit is always read as zero.
 *
 * Values:
 * - 0 - Do not clear the RX FIFO counter.
 * - 1 - Clear the RX FIFO counter.
 */
/*@{*/
#define BP_SPI_MCR_CLR_RXF   (10U)         /*!< Bit position for SPI_MCR_CLR_RXF. */
#define BM_SPI_MCR_CLR_RXF   (0x00000400U) /*!< Bit mask for SPI_MCR_CLR_RXF. */
#define BS_SPI_MCR_CLR_RXF   (1U)          /*!< Bit field size in bits for SPI_MCR_CLR_RXF. */

/*! @brief Format value for bitfield SPI_MCR_CLR_RXF. */
#define BF_SPI_MCR_CLR_RXF(v) ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_CLR_RXF) & BM_SPI_MCR_CLR_RXF)

/*! @brief Set the CLR_RXF field to a new value. */
#define BW_SPI_MCR_CLR_RXF(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_CLR_RXF) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field CLR_TXF[11] (WORZ)
 *
 * Flushes the TX FIFO. Writing a 1 to CLR_TXF clears the TX FIFO Counter. The
 * CLR_TXF bit is always read as zero.
 *
 * Values:
 * - 0 - Do not clear the TX FIFO counter.
 * - 1 - Clear the TX FIFO counter.
 */
/*@{*/
#define BP_SPI_MCR_CLR_TXF   (11U)         /*!< Bit position for SPI_MCR_CLR_TXF. */
#define BM_SPI_MCR_CLR_TXF   (0x00000800U) /*!< Bit mask for SPI_MCR_CLR_TXF. */
#define BS_SPI_MCR_CLR_TXF   (1U)          /*!< Bit field size in bits for SPI_MCR_CLR_TXF. */

/*! @brief Format value for bitfield SPI_MCR_CLR_TXF. */
#define BF_SPI_MCR_CLR_TXF(v) ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_CLR_TXF) & BM_SPI_MCR_CLR_TXF)

/*! @brief Set the CLR_TXF field to a new value. */
#define BW_SPI_MCR_CLR_TXF(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_CLR_TXF) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field DIS_RXF[12] (RW)
 *
 * When the RX FIFO is disabled, the receive part of the module operates as a
 * simplified double-buffered SPI. This bit can only be written when the MDIS bit
 * is cleared.
 *
 * Values:
 * - 0 - RX FIFO is enabled.
 * - 1 - RX FIFO is disabled.
 */
/*@{*/
#define BP_SPI_MCR_DIS_RXF   (12U)         /*!< Bit position for SPI_MCR_DIS_RXF. */
#define BM_SPI_MCR_DIS_RXF   (0x00001000U) /*!< Bit mask for SPI_MCR_DIS_RXF. */
#define BS_SPI_MCR_DIS_RXF   (1U)          /*!< Bit field size in bits for SPI_MCR_DIS_RXF. */

/*! @brief Read current value of the SPI_MCR_DIS_RXF field. */
#define BR_SPI_MCR_DIS_RXF(x) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_DIS_RXF))

/*! @brief Format value for bitfield SPI_MCR_DIS_RXF. */
#define BF_SPI_MCR_DIS_RXF(v) ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_DIS_RXF) & BM_SPI_MCR_DIS_RXF)

/*! @brief Set the DIS_RXF field to a new value. */
#define BW_SPI_MCR_DIS_RXF(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_DIS_RXF) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field DIS_TXF[13] (RW)
 *
 * When the TX FIFO is disabled, the transmit part of the module operates as a
 * simplified double-buffered SPI. This bit can be written only when the MDIS bit
 * is cleared.
 *
 * Values:
 * - 0 - TX FIFO is enabled.
 * - 1 - TX FIFO is disabled.
 */
/*@{*/
#define BP_SPI_MCR_DIS_TXF   (13U)         /*!< Bit position for SPI_MCR_DIS_TXF. */
#define BM_SPI_MCR_DIS_TXF   (0x00002000U) /*!< Bit mask for SPI_MCR_DIS_TXF. */
#define BS_SPI_MCR_DIS_TXF   (1U)          /*!< Bit field size in bits for SPI_MCR_DIS_TXF. */

/*! @brief Read current value of the SPI_MCR_DIS_TXF field. */
#define BR_SPI_MCR_DIS_TXF(x) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_DIS_TXF))

/*! @brief Format value for bitfield SPI_MCR_DIS_TXF. */
#define BF_SPI_MCR_DIS_TXF(v) ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_DIS_TXF) & BM_SPI_MCR_DIS_TXF)

/*! @brief Set the DIS_TXF field to a new value. */
#define BW_SPI_MCR_DIS_TXF(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_DIS_TXF) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field MDIS[14] (RW)
 *
 * Allows the clock to be stopped to the non-memory mapped logic in the module
 * effectively putting it in a software-controlled power-saving state. The reset
 * value of the MDIS bit is parameterized, with a default reset value of 0. When
 * the module is used in Slave Mode, we recommend leaving this bit 0, because a
 * slave doesn't have control over master transactions.
 *
 * Values:
 * - 0 - Enables the module clocks.
 * - 1 - Allows external logic to disable the module clocks.
 */
/*@{*/
#define BP_SPI_MCR_MDIS      (14U)         /*!< Bit position for SPI_MCR_MDIS. */
#define BM_SPI_MCR_MDIS      (0x00004000U) /*!< Bit mask for SPI_MCR_MDIS. */
#define BS_SPI_MCR_MDIS      (1U)          /*!< Bit field size in bits for SPI_MCR_MDIS. */

/*! @brief Read current value of the SPI_MCR_MDIS field. */
#define BR_SPI_MCR_MDIS(x)   (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_MDIS))

/*! @brief Format value for bitfield SPI_MCR_MDIS. */
#define BF_SPI_MCR_MDIS(v)   ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_MDIS) & BM_SPI_MCR_MDIS)

/*! @brief Set the MDIS field to a new value. */
#define BW_SPI_MCR_MDIS(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_MDIS) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field DOZE[15] (RW)
 *
 * Provides support for an externally controlled Doze mode power-saving
 * mechanism.
 *
 * Values:
 * - 0 - Doze mode has no effect on the module.
 * - 1 - Doze mode disables the module.
 */
/*@{*/
#define BP_SPI_MCR_DOZE      (15U)         /*!< Bit position for SPI_MCR_DOZE. */
#define BM_SPI_MCR_DOZE      (0x00008000U) /*!< Bit mask for SPI_MCR_DOZE. */
#define BS_SPI_MCR_DOZE      (1U)          /*!< Bit field size in bits for SPI_MCR_DOZE. */

/*! @brief Read current value of the SPI_MCR_DOZE field. */
#define BR_SPI_MCR_DOZE(x)   (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_DOZE))

/*! @brief Format value for bitfield SPI_MCR_DOZE. */
#define BF_SPI_MCR_DOZE(v)   ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_DOZE) & BM_SPI_MCR_DOZE)

/*! @brief Set the DOZE field to a new value. */
#define BW_SPI_MCR_DOZE(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_DOZE) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field PCSIS[21:16] (RW)
 *
 * Determines the inactive state of PCSx.
 *
 * Values:
 * - 0 - The inactive state of PCSx is low.
 * - 1 - The inactive state of PCSx is high.
 */
/*@{*/
#define BP_SPI_MCR_PCSIS     (16U)         /*!< Bit position for SPI_MCR_PCSIS. */
#define BM_SPI_MCR_PCSIS     (0x003F0000U) /*!< Bit mask for SPI_MCR_PCSIS. */
#define BS_SPI_MCR_PCSIS     (6U)          /*!< Bit field size in bits for SPI_MCR_PCSIS. */

/*! @brief Read current value of the SPI_MCR_PCSIS field. */
#define BR_SPI_MCR_PCSIS(x)  (HW_SPI_MCR(x).B.PCSIS)

/*! @brief Format value for bitfield SPI_MCR_PCSIS. */
#define BF_SPI_MCR_PCSIS(v)  ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_PCSIS) & BM_SPI_MCR_PCSIS)

/*! @brief Set the PCSIS field to a new value. */
#define BW_SPI_MCR_PCSIS(x, v) (HW_SPI_MCR_WR(x, (HW_SPI_MCR_RD(x) & ~BM_SPI_MCR_PCSIS) | BF_SPI_MCR_PCSIS(v)))
/*@}*/

/*!
 * @name Register SPI_MCR, field ROOE[24] (RW)
 *
 * In the RX FIFO overflow condition, configures the module to ignore the
 * incoming serial data or overwrite existing data. If the RX FIFO is full and new data
 * is received, the data from the transfer, generating the overflow, is ignored
 * or shifted into the shift register.
 *
 * Values:
 * - 0 - Incoming data is ignored.
 * - 1 - Incoming data is shifted into the shift register.
 */
/*@{*/
#define BP_SPI_MCR_ROOE      (24U)         /*!< Bit position for SPI_MCR_ROOE. */
#define BM_SPI_MCR_ROOE      (0x01000000U) /*!< Bit mask for SPI_MCR_ROOE. */
#define BS_SPI_MCR_ROOE      (1U)          /*!< Bit field size in bits for SPI_MCR_ROOE. */

/*! @brief Read current value of the SPI_MCR_ROOE field. */
#define BR_SPI_MCR_ROOE(x)   (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_ROOE))

/*! @brief Format value for bitfield SPI_MCR_ROOE. */
#define BF_SPI_MCR_ROOE(v)   ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_ROOE) & BM_SPI_MCR_ROOE)

/*! @brief Set the ROOE field to a new value. */
#define BW_SPI_MCR_ROOE(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_ROOE) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field PCSSE[25] (RW)
 *
 * Enables the PCS5/ PCSS to operate as a PCS Strobe output signal.
 *
 * Values:
 * - 0 - PCS5/ PCSS is used as the Peripheral Chip Select[5] signal.
 * - 1 - PCS5/ PCSS is used as an active-low PCS Strobe signal.
 */
/*@{*/
#define BP_SPI_MCR_PCSSE     (25U)         /*!< Bit position for SPI_MCR_PCSSE. */
#define BM_SPI_MCR_PCSSE     (0x02000000U) /*!< Bit mask for SPI_MCR_PCSSE. */
#define BS_SPI_MCR_PCSSE     (1U)          /*!< Bit field size in bits for SPI_MCR_PCSSE. */

/*! @brief Read current value of the SPI_MCR_PCSSE field. */
#define BR_SPI_MCR_PCSSE(x)  (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_PCSSE))

/*! @brief Format value for bitfield SPI_MCR_PCSSE. */
#define BF_SPI_MCR_PCSSE(v)  ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_PCSSE) & BM_SPI_MCR_PCSSE)

/*! @brief Set the PCSSE field to a new value. */
#define BW_SPI_MCR_PCSSE(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_PCSSE) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field MTFE[26] (RW)
 *
 * Enables a modified transfer format to be used.
 *
 * Values:
 * - 0 - Modified SPI transfer format disabled.
 * - 1 - Modified SPI transfer format enabled.
 */
/*@{*/
#define BP_SPI_MCR_MTFE      (26U)         /*!< Bit position for SPI_MCR_MTFE. */
#define BM_SPI_MCR_MTFE      (0x04000000U) /*!< Bit mask for SPI_MCR_MTFE. */
#define BS_SPI_MCR_MTFE      (1U)          /*!< Bit field size in bits for SPI_MCR_MTFE. */

/*! @brief Read current value of the SPI_MCR_MTFE field. */
#define BR_SPI_MCR_MTFE(x)   (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_MTFE))

/*! @brief Format value for bitfield SPI_MCR_MTFE. */
#define BF_SPI_MCR_MTFE(v)   ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_MTFE) & BM_SPI_MCR_MTFE)

/*! @brief Set the MTFE field to a new value. */
#define BW_SPI_MCR_MTFE(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_MTFE) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field FRZ[27] (RW)
 *
 * Enables transfers to be stopped on the next frame boundary when the device
 * enters Debug mode.
 *
 * Values:
 * - 0 - Do not halt serial transfers in Debug mode.
 * - 1 - Halt serial transfers in Debug mode.
 */
/*@{*/
#define BP_SPI_MCR_FRZ       (27U)         /*!< Bit position for SPI_MCR_FRZ. */
#define BM_SPI_MCR_FRZ       (0x08000000U) /*!< Bit mask for SPI_MCR_FRZ. */
#define BS_SPI_MCR_FRZ       (1U)          /*!< Bit field size in bits for SPI_MCR_FRZ. */

/*! @brief Read current value of the SPI_MCR_FRZ field. */
#define BR_SPI_MCR_FRZ(x)    (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_FRZ))

/*! @brief Format value for bitfield SPI_MCR_FRZ. */
#define BF_SPI_MCR_FRZ(v)    ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_FRZ) & BM_SPI_MCR_FRZ)

/*! @brief Set the FRZ field to a new value. */
#define BW_SPI_MCR_FRZ(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_FRZ) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field DCONF[29:28] (RO)
 *
 * Selects among the different configurations of the module.
 *
 * Values:
 * - 00 - SPI
 * - 01 - Reserved
 * - 10 - Reserved
 * - 11 - Reserved
 */
/*@{*/
#define BP_SPI_MCR_DCONF     (28U)         /*!< Bit position for SPI_MCR_DCONF. */
#define BM_SPI_MCR_DCONF     (0x30000000U) /*!< Bit mask for SPI_MCR_DCONF. */
#define BS_SPI_MCR_DCONF     (2U)          /*!< Bit field size in bits for SPI_MCR_DCONF. */

/*! @brief Read current value of the SPI_MCR_DCONF field. */
#define BR_SPI_MCR_DCONF(x)  (HW_SPI_MCR(x).B.DCONF)
/*@}*/

/*!
 * @name Register SPI_MCR, field CONT_SCKE[30] (RW)
 *
 * Enables the Serial Communication Clock (SCK) to run continuously.
 *
 * Values:
 * - 0 - Continuous SCK disabled.
 * - 1 - Continuous SCK enabled.
 */
/*@{*/
#define BP_SPI_MCR_CONT_SCKE (30U)         /*!< Bit position for SPI_MCR_CONT_SCKE. */
#define BM_SPI_MCR_CONT_SCKE (0x40000000U) /*!< Bit mask for SPI_MCR_CONT_SCKE. */
#define BS_SPI_MCR_CONT_SCKE (1U)          /*!< Bit field size in bits for SPI_MCR_CONT_SCKE. */

/*! @brief Read current value of the SPI_MCR_CONT_SCKE field. */
#define BR_SPI_MCR_CONT_SCKE(x) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_CONT_SCKE))

/*! @brief Format value for bitfield SPI_MCR_CONT_SCKE. */
#define BF_SPI_MCR_CONT_SCKE(v) ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_CONT_SCKE) & BM_SPI_MCR_CONT_SCKE)

/*! @brief Set the CONT_SCKE field to a new value. */
#define BW_SPI_MCR_CONT_SCKE(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_CONT_SCKE) = (v))
/*@}*/

/*!
 * @name Register SPI_MCR, field MSTR[31] (RW)
 *
 * Enables either Master mode (if supported) or Slave mode (if supported)
 * operation.
 *
 * Values:
 * - 0 - Enables Slave mode
 * - 1 - Enables Master mode
 */
/*@{*/
#define BP_SPI_MCR_MSTR      (31U)         /*!< Bit position for SPI_MCR_MSTR. */
#define BM_SPI_MCR_MSTR      (0x80000000U) /*!< Bit mask for SPI_MCR_MSTR. */
#define BS_SPI_MCR_MSTR      (1U)          /*!< Bit field size in bits for SPI_MCR_MSTR. */

/*! @brief Read current value of the SPI_MCR_MSTR field. */
#define BR_SPI_MCR_MSTR(x)   (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_MSTR))

/*! @brief Format value for bitfield SPI_MCR_MSTR. */
#define BF_SPI_MCR_MSTR(v)   ((uint32_t)((uint32_t)(v) << BP_SPI_MCR_MSTR) & BM_SPI_MCR_MSTR)

/*! @brief Set the MSTR field to a new value. */
#define BW_SPI_MCR_MSTR(x, v) (BITBAND_ACCESS32(HW_SPI_MCR_ADDR(x), BP_SPI_MCR_MSTR) = (v))
/*@}*/

/*******************************************************************************
 * HW_SPI_TCR - Transfer Count Register
 ******************************************************************************/

/*!
 * @brief HW_SPI_TCR - Transfer Count Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * TCR contains a counter that indicates the number of SPI transfers made. The
 * transfer counter is intended to assist in queue management. Do not write the
 * TCR when the module is in the Running state.
 */
typedef union _hw_spi_tcr
{
    uint32_t U;
    struct _hw_spi_tcr_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t SPI_TCNT : 16;        /*!< [31:16] SPI Transfer Counter */
    } B;
} hw_spi_tcr_t;

/*!
 * @name Constants and macros for entire SPI_TCR register
 */
/*@{*/
#define HW_SPI_TCR_ADDR(x)       ((x) + 0x8U)

#define HW_SPI_TCR(x)            (*(__IO hw_spi_tcr_t *) HW_SPI_TCR_ADDR(x))
#define HW_SPI_TCR_RD(x)         (HW_SPI_TCR(x).U)
#define HW_SPI_TCR_WR(x, v)      (HW_SPI_TCR(x).U = (v))
#define HW_SPI_TCR_SET(x, v)     (HW_SPI_TCR_WR(x, HW_SPI_TCR_RD(x) |  (v)))
#define HW_SPI_TCR_CLR(x, v)     (HW_SPI_TCR_WR(x, HW_SPI_TCR_RD(x) & ~(v)))
#define HW_SPI_TCR_TOG(x, v)     (HW_SPI_TCR_WR(x, HW_SPI_TCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SPI_TCR bitfields
 */

/*!
 * @name Register SPI_TCR, field SPI_TCNT[31:16] (RW)
 *
 * Counts the number of SPI transfers the module makes. The SPI_TCNT field
 * increments every time the last bit of an SPI frame is transmitted. A value written
 * to SPI_TCNT presets the counter to that value. SPI_TCNT is reset to zero at
 * the beginning of the frame when the CTCNT field is set in the executing SPI
 * command. The Transfer Counter wraps around; incrementing the counter past 65535
 * resets the counter to zero.
 */
/*@{*/
#define BP_SPI_TCR_SPI_TCNT  (16U)         /*!< Bit position for SPI_TCR_SPI_TCNT. */
#define BM_SPI_TCR_SPI_TCNT  (0xFFFF0000U) /*!< Bit mask for SPI_TCR_SPI_TCNT. */
#define BS_SPI_TCR_SPI_TCNT  (16U)         /*!< Bit field size in bits for SPI_TCR_SPI_TCNT. */

/*! @brief Read current value of the SPI_TCR_SPI_TCNT field. */
#define BR_SPI_TCR_SPI_TCNT(x) (HW_SPI_TCR(x).B.SPI_TCNT)

/*! @brief Format value for bitfield SPI_TCR_SPI_TCNT. */
#define BF_SPI_TCR_SPI_TCNT(v) ((uint32_t)((uint32_t)(v) << BP_SPI_TCR_SPI_TCNT) & BM_SPI_TCR_SPI_TCNT)

/*! @brief Set the SPI_TCNT field to a new value. */
#define BW_SPI_TCR_SPI_TCNT(x, v) (HW_SPI_TCR_WR(x, (HW_SPI_TCR_RD(x) & ~BM_SPI_TCR_SPI_TCNT) | BF_SPI_TCR_SPI_TCNT(v)))
/*@}*/

/*******************************************************************************
 * HW_SPI_CTARn - Clock and Transfer Attributes Register (In Master Mode)
 ******************************************************************************/

/*!
 * @brief HW_SPI_CTARn - Clock and Transfer Attributes Register (In Master Mode) (RW)
 *
 * Reset value: 0x78000000U
 *
 * CTAR registers are used to define different transfer attributes. Do not write
 * to the CTAR registers while the module is in the Running state. In Master
 * mode, the CTAR registers define combinations of transfer attributes such as frame
 * size, clock phase and polarity, data bit ordering, baud rate, and various
 * delays. In slave mode, a subset of the bitfields in CTAR0 are used to set the
 * slave transfer attributes. When the module is configured as an SPI master, the
 * CTAS field in the command portion of the TX FIFO entry selects which of the CTAR
 * registers is used. When the module is configured as an SPI bus slave, it uses
 * the CTAR0 register.
 */
typedef union _hw_spi_ctarn
{
    uint32_t U;
    struct _hw_spi_ctarn_bitfields
    {
        uint32_t BR : 4;               /*!< [3:0] Baud Rate Scaler */
        uint32_t DT : 4;               /*!< [7:4] Delay After Transfer Scaler */
        uint32_t ASC : 4;              /*!< [11:8] After SCK Delay Scaler */
        uint32_t CSSCK : 4;            /*!< [15:12] PCS to SCK Delay Scaler */
        uint32_t PBR : 2;              /*!< [17:16] Baud Rate Prescaler */
        uint32_t PDT : 2;              /*!< [19:18] Delay after Transfer Prescaler */
        uint32_t PASC : 2;             /*!< [21:20] After SCK Delay Prescaler */
        uint32_t PCSSCK : 2;           /*!< [23:22] PCS to SCK Delay Prescaler */
        uint32_t LSBFE : 1;            /*!< [24] LSB First */
        uint32_t CPHA : 1;             /*!< [25] Clock Phase */
        uint32_t CPOL : 1;             /*!< [26] Clock Polarity */
        uint32_t FMSZ : 4;             /*!< [30:27] Frame Size */
        uint32_t DBR : 1;              /*!< [31] Double Baud Rate */
    } B;
} hw_spi_ctarn_t;

/*!
 * @name Constants and macros for entire SPI_CTARn register
 */
/*@{*/
#define HW_SPI_CTARn_COUNT (2U)

#define HW_SPI_CTARn_ADDR(x, n)  ((x) + 0xCU + (0x4U * (n)))

#define HW_SPI_CTARn(x, n)       (*(__IO hw_spi_ctarn_t *) HW_SPI_CTARn_ADDR(x, n))
#define HW_SPI_CTARn_RD(x, n)    (HW_SPI_CTARn(x, n).U)
#define HW_SPI_CTARn_WR(x, n, v) (HW_SPI_CTARn(x, n).U = (v))
#define HW_SPI_CTARn_SET(x, n, v) (HW_SPI_CTARn_WR(x, n, HW_SPI_CTARn_RD(x, n) |  (v)))
#define HW_SPI_CTARn_CLR(x, n, v) (HW_SPI_CTARn_WR(x, n, HW_SPI_CTARn_RD(x, n) & ~(v)))
#define HW_SPI_CTARn_TOG(x, n, v) (HW_SPI_CTARn_WR(x, n, HW_SPI_CTARn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SPI_CTARn bitfields
 */

/*!
 * @name Register SPI_CTARn, field BR[3:0] (RW)
 *
 * Selects the scaler value for the baud rate. This field is used only in master
 * mode. The prescaled protocol clock is divided by the Baud Rate Scaler to
 * generate the frequency of the SCK. The baud rate is computed according to the
 * following equation: SCK baud rate = (fP /PBR) x [(1+DBR)/BR] The following table
 * lists the baud rate scaler values. Baud Rate Scaler CTARn[BR] Baud Rate Scaler
 * Value 0000 2 0001 4 0010 6 0011 8 0100 16 0101 32 0110 64 0111 128 1000 256
 * 1001 512 1010 1024 1011 2048 1100 4096 1101 8192 1110 16384 1111 32768
 */
/*@{*/
#define BP_SPI_CTARn_BR      (0U)          /*!< Bit position for SPI_CTARn_BR. */
#define BM_SPI_CTARn_BR      (0x0000000FU) /*!< Bit mask for SPI_CTARn_BR. */
#define BS_SPI_CTARn_BR      (4U)          /*!< Bit field size in bits for SPI_CTARn_BR. */

/*! @brief Read current value of the SPI_CTARn_BR field. */
#define BR_SPI_CTARn_BR(x, n) (HW_SPI_CTARn(x, n).B.BR)

/*! @brief Format value for bitfield SPI_CTARn_BR. */
#define BF_SPI_CTARn_BR(v)   ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_BR) & BM_SPI_CTARn_BR)

/*! @brief Set the BR field to a new value. */
#define BW_SPI_CTARn_BR(x, n, v) (HW_SPI_CTARn_WR(x, n, (HW_SPI_CTARn_RD(x, n) & ~BM_SPI_CTARn_BR) | BF_SPI_CTARn_BR(v)))
/*@}*/

/*!
 * @name Register SPI_CTARn, field DT[7:4] (RW)
 *
 * Selects the Delay after Transfer Scaler. This field is used only in master
 * mode. The Delay after Transfer is the time between the negation of the PCS
 * signal at the end of a frame and the assertion of PCS at the beginning of the next
 * frame. In the Continuous Serial Communications Clock operation, the DT value
 * is fixed to one SCK clock period, The Delay after Transfer is a multiple of the
 * protocol clock period, and it is computed according to the following
 * equation: tDT = (1/fP ) x PDT x DT See Delay Scaler Encoding table in CTARn[CSSCK] bit
 * field description for scaler values.
 */
/*@{*/
#define BP_SPI_CTARn_DT      (4U)          /*!< Bit position for SPI_CTARn_DT. */
#define BM_SPI_CTARn_DT      (0x000000F0U) /*!< Bit mask for SPI_CTARn_DT. */
#define BS_SPI_CTARn_DT      (4U)          /*!< Bit field size in bits for SPI_CTARn_DT. */

/*! @brief Read current value of the SPI_CTARn_DT field. */
#define BR_SPI_CTARn_DT(x, n) (HW_SPI_CTARn(x, n).B.DT)

/*! @brief Format value for bitfield SPI_CTARn_DT. */
#define BF_SPI_CTARn_DT(v)   ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_DT) & BM_SPI_CTARn_DT)

/*! @brief Set the DT field to a new value. */
#define BW_SPI_CTARn_DT(x, n, v) (HW_SPI_CTARn_WR(x, n, (HW_SPI_CTARn_RD(x, n) & ~BM_SPI_CTARn_DT) | BF_SPI_CTARn_DT(v)))
/*@}*/

/*!
 * @name Register SPI_CTARn, field ASC[11:8] (RW)
 *
 * Selects the scaler value for the After SCK Delay. This field is used only in
 * master mode. The After SCK Delay is the delay between the last edge of SCK and
 * the negation of PCS. The delay is a multiple of the protocol clock period,
 * and it is computed according to the following equation: t ASC = (1/fP) x PASC x
 * ASC See Delay Scaler Encoding table in CTARn[CSSCK] bit field description for
 * scaler values. Refer After SCK Delay (tASC ) for more details.
 */
/*@{*/
#define BP_SPI_CTARn_ASC     (8U)          /*!< Bit position for SPI_CTARn_ASC. */
#define BM_SPI_CTARn_ASC     (0x00000F00U) /*!< Bit mask for SPI_CTARn_ASC. */
#define BS_SPI_CTARn_ASC     (4U)          /*!< Bit field size in bits for SPI_CTARn_ASC. */

/*! @brief Read current value of the SPI_CTARn_ASC field. */
#define BR_SPI_CTARn_ASC(x, n) (HW_SPI_CTARn(x, n).B.ASC)

/*! @brief Format value for bitfield SPI_CTARn_ASC. */
#define BF_SPI_CTARn_ASC(v)  ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_ASC) & BM_SPI_CTARn_ASC)

/*! @brief Set the ASC field to a new value. */
#define BW_SPI_CTARn_ASC(x, n, v) (HW_SPI_CTARn_WR(x, n, (HW_SPI_CTARn_RD(x, n) & ~BM_SPI_CTARn_ASC) | BF_SPI_CTARn_ASC(v)))
/*@}*/

/*!
 * @name Register SPI_CTARn, field CSSCK[15:12] (RW)
 *
 * Selects the scaler value for the PCS to SCK delay. This field is used only in
 * master mode. The PCS to SCK Delay is the delay between the assertion of PCS
 * and the first edge of the SCK. The delay is a multiple of the protocol clock
 * period, and it is computed according to the following equation: t CSC = (1/fP )
 * x PCSSCK x CSSCK. The following table lists the delay scaler values. Delay
 * Scaler Encoding Field Value Delay Scaler Value 0000 2 0001 4 0010 8 0011 16 0100
 * 32 0101 64 0110 128 0111 256 1000 512 1001 1024 1010 2048 1011 4096 1100 8192
 * 1101 16384 1110 32768 1111 65536 Refer PCS to SCK Delay (tCSC ) for more
 * details.
 */
/*@{*/
#define BP_SPI_CTARn_CSSCK   (12U)         /*!< Bit position for SPI_CTARn_CSSCK. */
#define BM_SPI_CTARn_CSSCK   (0x0000F000U) /*!< Bit mask for SPI_CTARn_CSSCK. */
#define BS_SPI_CTARn_CSSCK   (4U)          /*!< Bit field size in bits for SPI_CTARn_CSSCK. */

/*! @brief Read current value of the SPI_CTARn_CSSCK field. */
#define BR_SPI_CTARn_CSSCK(x, n) (HW_SPI_CTARn(x, n).B.CSSCK)

/*! @brief Format value for bitfield SPI_CTARn_CSSCK. */
#define BF_SPI_CTARn_CSSCK(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_CSSCK) & BM_SPI_CTARn_CSSCK)

/*! @brief Set the CSSCK field to a new value. */
#define BW_SPI_CTARn_CSSCK(x, n, v) (HW_SPI_CTARn_WR(x, n, (HW_SPI_CTARn_RD(x, n) & ~BM_SPI_CTARn_CSSCK) | BF_SPI_CTARn_CSSCK(v)))
/*@}*/

/*!
 * @name Register SPI_CTARn, field PBR[17:16] (RW)
 *
 * Selects the prescaler value for the baud rate. This field is used only in
 * master mode. The baud rate is the frequency of the SCK. The protocol clock is
 * divided by the prescaler value before the baud rate selection takes place. See
 * the BR field description for details on how to compute the baud rate.
 *
 * Values:
 * - 00 - Baud Rate Prescaler value is 2.
 * - 01 - Baud Rate Prescaler value is 3.
 * - 10 - Baud Rate Prescaler value is 5.
 * - 11 - Baud Rate Prescaler value is 7.
 */
/*@{*/
#define BP_SPI_CTARn_PBR     (16U)         /*!< Bit position for SPI_CTARn_PBR. */
#define BM_SPI_CTARn_PBR     (0x00030000U) /*!< Bit mask for SPI_CTARn_PBR. */
#define BS_SPI_CTARn_PBR     (2U)          /*!< Bit field size in bits for SPI_CTARn_PBR. */

/*! @brief Read current value of the SPI_CTARn_PBR field. */
#define BR_SPI_CTARn_PBR(x, n) (HW_SPI_CTARn(x, n).B.PBR)

/*! @brief Format value for bitfield SPI_CTARn_PBR. */
#define BF_SPI_CTARn_PBR(v)  ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_PBR) & BM_SPI_CTARn_PBR)

/*! @brief Set the PBR field to a new value. */
#define BW_SPI_CTARn_PBR(x, n, v) (HW_SPI_CTARn_WR(x, n, (HW_SPI_CTARn_RD(x, n) & ~BM_SPI_CTARn_PBR) | BF_SPI_CTARn_PBR(v)))
/*@}*/

/*!
 * @name Register SPI_CTARn, field PDT[19:18] (RW)
 *
 * Selects the prescaler value for the delay between the negation of the PCS
 * signal at the end of a frame and the assertion of PCS at the beginning of the
 * next frame. The PDT field is only used in master mode. See the DT field
 * description for details on how to compute the Delay after Transfer. Refer Delay after
 * Transfer (tDT ) for more details.
 *
 * Values:
 * - 00 - Delay after Transfer Prescaler value is 1.
 * - 01 - Delay after Transfer Prescaler value is 3.
 * - 10 - Delay after Transfer Prescaler value is 5.
 * - 11 - Delay after Transfer Prescaler value is 7.
 */
/*@{*/
#define BP_SPI_CTARn_PDT     (18U)         /*!< Bit position for SPI_CTARn_PDT. */
#define BM_SPI_CTARn_PDT     (0x000C0000U) /*!< Bit mask for SPI_CTARn_PDT. */
#define BS_SPI_CTARn_PDT     (2U)          /*!< Bit field size in bits for SPI_CTARn_PDT. */

/*! @brief Read current value of the SPI_CTARn_PDT field. */
#define BR_SPI_CTARn_PDT(x, n) (HW_SPI_CTARn(x, n).B.PDT)

/*! @brief Format value for bitfield SPI_CTARn_PDT. */
#define BF_SPI_CTARn_PDT(v)  ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_PDT) & BM_SPI_CTARn_PDT)

/*! @brief Set the PDT field to a new value. */
#define BW_SPI_CTARn_PDT(x, n, v) (HW_SPI_CTARn_WR(x, n, (HW_SPI_CTARn_RD(x, n) & ~BM_SPI_CTARn_PDT) | BF_SPI_CTARn_PDT(v)))
/*@}*/

/*!
 * @name Register SPI_CTARn, field PASC[21:20] (RW)
 *
 * Selects the prescaler value for the delay between the last edge of SCK and
 * the negation of PCS. See the ASC field description for information on how to
 * compute the After SCK Delay. Refer After SCK Delay (tASC ) for more details.
 *
 * Values:
 * - 00 - Delay after Transfer Prescaler value is 1.
 * - 01 - Delay after Transfer Prescaler value is 3.
 * - 10 - Delay after Transfer Prescaler value is 5.
 * - 11 - Delay after Transfer Prescaler value is 7.
 */
/*@{*/
#define BP_SPI_CTARn_PASC    (20U)         /*!< Bit position for SPI_CTARn_PASC. */
#define BM_SPI_CTARn_PASC    (0x00300000U) /*!< Bit mask for SPI_CTARn_PASC. */
#define BS_SPI_CTARn_PASC    (2U)          /*!< Bit field size in bits for SPI_CTARn_PASC. */

/*! @brief Read current value of the SPI_CTARn_PASC field. */
#define BR_SPI_CTARn_PASC(x, n) (HW_SPI_CTARn(x, n).B.PASC)

/*! @brief Format value for bitfield SPI_CTARn_PASC. */
#define BF_SPI_CTARn_PASC(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_PASC) & BM_SPI_CTARn_PASC)

/*! @brief Set the PASC field to a new value. */
#define BW_SPI_CTARn_PASC(x, n, v) (HW_SPI_CTARn_WR(x, n, (HW_SPI_CTARn_RD(x, n) & ~BM_SPI_CTARn_PASC) | BF_SPI_CTARn_PASC(v)))
/*@}*/

/*!
 * @name Register SPI_CTARn, field PCSSCK[23:22] (RW)
 *
 * Selects the prescaler value for the delay between assertion of PCS and the
 * first edge of the SCK. See the CSSCK field description for information on how to
 * compute the PCS to SCK Delay. Refer PCS to SCK Delay (tCSC ) for more details.
 *
 * Values:
 * - 00 - PCS to SCK Prescaler value is 1.
 * - 01 - PCS to SCK Prescaler value is 3.
 * - 10 - PCS to SCK Prescaler value is 5.
 * - 11 - PCS to SCK Prescaler value is 7.
 */
/*@{*/
#define BP_SPI_CTARn_PCSSCK  (22U)         /*!< Bit position for SPI_CTARn_PCSSCK. */
#define BM_SPI_CTARn_PCSSCK  (0x00C00000U) /*!< Bit mask for SPI_CTARn_PCSSCK. */
#define BS_SPI_CTARn_PCSSCK  (2U)          /*!< Bit field size in bits for SPI_CTARn_PCSSCK. */

/*! @brief Read current value of the SPI_CTARn_PCSSCK field. */
#define BR_SPI_CTARn_PCSSCK(x, n) (HW_SPI_CTARn(x, n).B.PCSSCK)

/*! @brief Format value for bitfield SPI_CTARn_PCSSCK. */
#define BF_SPI_CTARn_PCSSCK(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_PCSSCK) & BM_SPI_CTARn_PCSSCK)

/*! @brief Set the PCSSCK field to a new value. */
#define BW_SPI_CTARn_PCSSCK(x, n, v) (HW_SPI_CTARn_WR(x, n, (HW_SPI_CTARn_RD(x, n) & ~BM_SPI_CTARn_PCSSCK) | BF_SPI_CTARn_PCSSCK(v)))
/*@}*/

/*!
 * @name Register SPI_CTARn, field LSBFE[24] (RW)
 *
 * Specifies whether the LSB or MSB of the frame is transferred first.
 *
 * Values:
 * - 0 - Data is transferred MSB first.
 * - 1 - Data is transferred LSB first.
 */
/*@{*/
#define BP_SPI_CTARn_LSBFE   (24U)         /*!< Bit position for SPI_CTARn_LSBFE. */
#define BM_SPI_CTARn_LSBFE   (0x01000000U) /*!< Bit mask for SPI_CTARn_LSBFE. */
#define BS_SPI_CTARn_LSBFE   (1U)          /*!< Bit field size in bits for SPI_CTARn_LSBFE. */

/*! @brief Read current value of the SPI_CTARn_LSBFE field. */
#define BR_SPI_CTARn_LSBFE(x, n) (BITBAND_ACCESS32(HW_SPI_CTARn_ADDR(x, n), BP_SPI_CTARn_LSBFE))

/*! @brief Format value for bitfield SPI_CTARn_LSBFE. */
#define BF_SPI_CTARn_LSBFE(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_LSBFE) & BM_SPI_CTARn_LSBFE)

/*! @brief Set the LSBFE field to a new value. */
#define BW_SPI_CTARn_LSBFE(x, n, v) (BITBAND_ACCESS32(HW_SPI_CTARn_ADDR(x, n), BP_SPI_CTARn_LSBFE) = (v))
/*@}*/

/*!
 * @name Register SPI_CTARn, field CPHA[25] (RW)
 *
 * Selects which edge of SCK causes data to change and which edge causes data to
 * be captured. This bit is used in both master and slave mode. For successful
 * communication between serial devices, the devices must have identical clock
 * phase settings. In Continuous SCK mode, the bit value is ignored and the
 * transfers are done as if the CPHA bit is set to 1.
 *
 * Values:
 * - 0 - Data is captured on the leading edge of SCK and changed on the
 *     following edge.
 * - 1 - Data is changed on the leading edge of SCK and captured on the
 *     following edge.
 */
/*@{*/
#define BP_SPI_CTARn_CPHA    (25U)         /*!< Bit position for SPI_CTARn_CPHA. */
#define BM_SPI_CTARn_CPHA    (0x02000000U) /*!< Bit mask for SPI_CTARn_CPHA. */
#define BS_SPI_CTARn_CPHA    (1U)          /*!< Bit field size in bits for SPI_CTARn_CPHA. */

/*! @brief Read current value of the SPI_CTARn_CPHA field. */
#define BR_SPI_CTARn_CPHA(x, n) (BITBAND_ACCESS32(HW_SPI_CTARn_ADDR(x, n), BP_SPI_CTARn_CPHA))

/*! @brief Format value for bitfield SPI_CTARn_CPHA. */
#define BF_SPI_CTARn_CPHA(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_CPHA) & BM_SPI_CTARn_CPHA)

/*! @brief Set the CPHA field to a new value. */
#define BW_SPI_CTARn_CPHA(x, n, v) (BITBAND_ACCESS32(HW_SPI_CTARn_ADDR(x, n), BP_SPI_CTARn_CPHA) = (v))
/*@}*/

/*!
 * @name Register SPI_CTARn, field CPOL[26] (RW)
 *
 * Selects the inactive state of the Serial Communications Clock (SCK). This bit
 * is used in both master and slave mode. For successful communication between
 * serial devices, the devices must have identical clock polarities. When the
 * Continuous Selection Format is selected, switching between clock polarities
 * without stopping the module can cause errors in the transfer due to the peripheral
 * device interpreting the switch of clock polarity as a valid clock edge. In case
 * of continous sck mode, when the module goes in low power mode(disabled),
 * inactive state of sck is not guaranted.
 *
 * Values:
 * - 0 - The inactive state value of SCK is low.
 * - 1 - The inactive state value of SCK is high.
 */
/*@{*/
#define BP_SPI_CTARn_CPOL    (26U)         /*!< Bit position for SPI_CTARn_CPOL. */
#define BM_SPI_CTARn_CPOL    (0x04000000U) /*!< Bit mask for SPI_CTARn_CPOL. */
#define BS_SPI_CTARn_CPOL    (1U)          /*!< Bit field size in bits for SPI_CTARn_CPOL. */

/*! @brief Read current value of the SPI_CTARn_CPOL field. */
#define BR_SPI_CTARn_CPOL(x, n) (BITBAND_ACCESS32(HW_SPI_CTARn_ADDR(x, n), BP_SPI_CTARn_CPOL))

/*! @brief Format value for bitfield SPI_CTARn_CPOL. */
#define BF_SPI_CTARn_CPOL(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_CPOL) & BM_SPI_CTARn_CPOL)

/*! @brief Set the CPOL field to a new value. */
#define BW_SPI_CTARn_CPOL(x, n, v) (BITBAND_ACCESS32(HW_SPI_CTARn_ADDR(x, n), BP_SPI_CTARn_CPOL) = (v))
/*@}*/

/*!
 * @name Register SPI_CTARn, field FMSZ[30:27] (RW)
 *
 * The number of bits transferred per frame is equal to the FMSZ value plus 1.
 * Regardless of the transmission mode, the minimum valid frame size value is 4.
 */
/*@{*/
#define BP_SPI_CTARn_FMSZ    (27U)         /*!< Bit position for SPI_CTARn_FMSZ. */
#define BM_SPI_CTARn_FMSZ    (0x78000000U) /*!< Bit mask for SPI_CTARn_FMSZ. */
#define BS_SPI_CTARn_FMSZ    (4U)          /*!< Bit field size in bits for SPI_CTARn_FMSZ. */

/*! @brief Read current value of the SPI_CTARn_FMSZ field. */
#define BR_SPI_CTARn_FMSZ(x, n) (HW_SPI_CTARn(x, n).B.FMSZ)

/*! @brief Format value for bitfield SPI_CTARn_FMSZ. */
#define BF_SPI_CTARn_FMSZ(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_FMSZ) & BM_SPI_CTARn_FMSZ)

/*! @brief Set the FMSZ field to a new value. */
#define BW_SPI_CTARn_FMSZ(x, n, v) (HW_SPI_CTARn_WR(x, n, (HW_SPI_CTARn_RD(x, n) & ~BM_SPI_CTARn_FMSZ) | BF_SPI_CTARn_FMSZ(v)))
/*@}*/

/*!
 * @name Register SPI_CTARn, field DBR[31] (RW)
 *
 * Doubles the effective baud rate of the Serial Communications Clock (SCK).
 * This field is used only in master mode. It effectively halves the Baud Rate
 * division ratio, supporting faster frequencies, and odd division ratios for the
 * Serial Communications Clock (SCK). When the DBR bit is set, the duty cycle of the
 * Serial Communications Clock (SCK) depends on the value in the Baud Rate
 * Prescaler and the Clock Phase bit as listed in the following table. See the BR field
 * description for details on how to compute the baud rate. SPI SCK Duty Cycle
 * DBR CPHA PBR SCK Duty Cycle 0 any any 50/50 1 0 00 50/50 1 0 01 33/66 1 0 10
 * 40/60 1 0 11 43/57 1 1 00 50/50 1 1 01 66/33 1 1 10 60/40 1 1 11 57/43
 *
 * Values:
 * - 0 - The baud rate is computed normally with a 50/50 duty cycle.
 * - 1 - The baud rate is doubled with the duty cycle depending on the Baud Rate
 *     Prescaler.
 */
/*@{*/
#define BP_SPI_CTARn_DBR     (31U)         /*!< Bit position for SPI_CTARn_DBR. */
#define BM_SPI_CTARn_DBR     (0x80000000U) /*!< Bit mask for SPI_CTARn_DBR. */
#define BS_SPI_CTARn_DBR     (1U)          /*!< Bit field size in bits for SPI_CTARn_DBR. */

/*! @brief Read current value of the SPI_CTARn_DBR field. */
#define BR_SPI_CTARn_DBR(x, n) (BITBAND_ACCESS32(HW_SPI_CTARn_ADDR(x, n), BP_SPI_CTARn_DBR))

/*! @brief Format value for bitfield SPI_CTARn_DBR. */
#define BF_SPI_CTARn_DBR(v)  ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_DBR) & BM_SPI_CTARn_DBR)

/*! @brief Set the DBR field to a new value. */
#define BW_SPI_CTARn_DBR(x, n, v) (BITBAND_ACCESS32(HW_SPI_CTARn_ADDR(x, n), BP_SPI_CTARn_DBR) = (v))
/*@}*/
/*******************************************************************************
 * HW_SPI_CTARn_SLAVE - Clock and Transfer Attributes Register (In Slave Mode)
 ******************************************************************************/

/*!
 * @brief HW_SPI_CTARn_SLAVE - Clock and Transfer Attributes Register (In Slave Mode) (RW)
 *
 * Reset value: 0x78000000U
 *
 * When the module is configured as an SPI bus slave, the CTAR0 register is used.
 */
typedef union _hw_spi_ctarn_slave
{
    uint32_t U;
    struct _hw_spi_ctarn_slave_bitfields
    {
        uint32_t RESERVED0 : 25;       /*!< [24:0]  */
        uint32_t CPHA : 1;             /*!< [25] Clock Phase */
        uint32_t CPOL : 1;             /*!< [26] Clock Polarity */
        uint32_t FMSZ : 5;             /*!< [31:27] Frame Size */
    } B;
} hw_spi_ctarn_slave_t;

/*!
 * @name Constants and macros for entire SPI_CTARn_SLAVE register
 */
/*@{*/
#define HW_SPI_CTARn_SLAVE_COUNT (1U)

#define HW_SPI_CTARn_SLAVE_ADDR(x, n) ((x) + 0xCU + (0x4U * (n)))

#define HW_SPI_CTARn_SLAVE(x, n) (*(__IO hw_spi_ctarn_slave_t *) HW_SPI_CTARn_SLAVE_ADDR(x, n))
#define HW_SPI_CTARn_SLAVE_RD(x, n) (HW_SPI_CTARn_SLAVE(x, n).U)
#define HW_SPI_CTARn_SLAVE_WR(x, n, v) (HW_SPI_CTARn_SLAVE(x, n).U = (v))
#define HW_SPI_CTARn_SLAVE_SET(x, n, v) (HW_SPI_CTARn_SLAVE_WR(x, n, HW_SPI_CTARn_SLAVE_RD(x, n) |  (v)))
#define HW_SPI_CTARn_SLAVE_CLR(x, n, v) (HW_SPI_CTARn_SLAVE_WR(x, n, HW_SPI_CTARn_SLAVE_RD(x, n) & ~(v)))
#define HW_SPI_CTARn_SLAVE_TOG(x, n, v) (HW_SPI_CTARn_SLAVE_WR(x, n, HW_SPI_CTARn_SLAVE_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SPI_CTARn_SLAVE bitfields
 */

/*!
 * @name Register SPI_CTARn_SLAVE, field CPHA[25] (RW)
 *
 * Selects which edge of SCK causes data to change and which edge causes data to
 * be captured. This bit is used in both master and slave mode. For successful
 * communication between serial devices, the devices must have identical clock
 * phase settings. In Continuous SCK mode, the bit value is ignored and the
 * transfers are done as if the CPHA bit is set to 1.
 *
 * Values:
 * - 0 - Data is captured on the leading edge of SCK and changed on the
 *     following edge.
 * - 1 - Data is changed on the leading edge of SCK and captured on the
 *     following edge.
 */
/*@{*/
#define BP_SPI_CTARn_SLAVE_CPHA (25U)      /*!< Bit position for SPI_CTARn_SLAVE_CPHA. */
#define BM_SPI_CTARn_SLAVE_CPHA (0x02000000U) /*!< Bit mask for SPI_CTARn_SLAVE_CPHA. */
#define BS_SPI_CTARn_SLAVE_CPHA (1U)       /*!< Bit field size in bits for SPI_CTARn_SLAVE_CPHA. */

/*! @brief Read current value of the SPI_CTARn_SLAVE_CPHA field. */
#define BR_SPI_CTARn_SLAVE_CPHA(x, n) (BITBAND_ACCESS32(HW_SPI_CTARn_SLAVE_ADDR(x, n), BP_SPI_CTARn_SLAVE_CPHA))

/*! @brief Format value for bitfield SPI_CTARn_SLAVE_CPHA. */
#define BF_SPI_CTARn_SLAVE_CPHA(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_SLAVE_CPHA) & BM_SPI_CTARn_SLAVE_CPHA)

/*! @brief Set the CPHA field to a new value. */
#define BW_SPI_CTARn_SLAVE_CPHA(x, n, v) (BITBAND_ACCESS32(HW_SPI_CTARn_SLAVE_ADDR(x, n), BP_SPI_CTARn_SLAVE_CPHA) = (v))
/*@}*/

/*!
 * @name Register SPI_CTARn_SLAVE, field CPOL[26] (RW)
 *
 * Selects the inactive state of the Serial Communications Clock (SCK). In case
 * of continous sck mode, when the module goes in low power mode(disabled),
 * inactive state of sck is not guaranted.
 *
 * Values:
 * - 0 - The inactive state value of SCK is low.
 * - 1 - The inactive state value of SCK is high.
 */
/*@{*/
#define BP_SPI_CTARn_SLAVE_CPOL (26U)      /*!< Bit position for SPI_CTARn_SLAVE_CPOL. */
#define BM_SPI_CTARn_SLAVE_CPOL (0x04000000U) /*!< Bit mask for SPI_CTARn_SLAVE_CPOL. */
#define BS_SPI_CTARn_SLAVE_CPOL (1U)       /*!< Bit field size in bits for SPI_CTARn_SLAVE_CPOL. */

/*! @brief Read current value of the SPI_CTARn_SLAVE_CPOL field. */
#define BR_SPI_CTARn_SLAVE_CPOL(x, n) (BITBAND_ACCESS32(HW_SPI_CTARn_SLAVE_ADDR(x, n), BP_SPI_CTARn_SLAVE_CPOL))

/*! @brief Format value for bitfield SPI_CTARn_SLAVE_CPOL. */
#define BF_SPI_CTARn_SLAVE_CPOL(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_SLAVE_CPOL) & BM_SPI_CTARn_SLAVE_CPOL)

/*! @brief Set the CPOL field to a new value. */
#define BW_SPI_CTARn_SLAVE_CPOL(x, n, v) (BITBAND_ACCESS32(HW_SPI_CTARn_SLAVE_ADDR(x, n), BP_SPI_CTARn_SLAVE_CPOL) = (v))
/*@}*/

/*!
 * @name Register SPI_CTARn_SLAVE, field FMSZ[31:27] (RW)
 *
 * The number of bits transfered per frame is equal to the FMSZ field value plus
 * 1. Note that the minimum valid value of frame size is 4.
 */
/*@{*/
#define BP_SPI_CTARn_SLAVE_FMSZ (27U)      /*!< Bit position for SPI_CTARn_SLAVE_FMSZ. */
#define BM_SPI_CTARn_SLAVE_FMSZ (0xF8000000U) /*!< Bit mask for SPI_CTARn_SLAVE_FMSZ. */
#define BS_SPI_CTARn_SLAVE_FMSZ (5U)       /*!< Bit field size in bits for SPI_CTARn_SLAVE_FMSZ. */

/*! @brief Read current value of the SPI_CTARn_SLAVE_FMSZ field. */
#define BR_SPI_CTARn_SLAVE_FMSZ(x, n) (HW_SPI_CTARn_SLAVE(x, n).B.FMSZ)

/*! @brief Format value for bitfield SPI_CTARn_SLAVE_FMSZ. */
#define BF_SPI_CTARn_SLAVE_FMSZ(v) ((uint32_t)((uint32_t)(v) << BP_SPI_CTARn_SLAVE_FMSZ) & BM_SPI_CTARn_SLAVE_FMSZ)

/*! @brief Set the FMSZ field to a new value. */
#define BW_SPI_CTARn_SLAVE_FMSZ(x, n, v) (HW_SPI_CTARn_SLAVE_WR(x, n, (HW_SPI_CTARn_SLAVE_RD(x, n) & ~BM_SPI_CTARn_SLAVE_FMSZ) | BF_SPI_CTARn_SLAVE_FMSZ(v)))
/*@}*/

/*******************************************************************************
 * HW_SPI_SR - Status Register
 ******************************************************************************/

/*!
 * @brief HW_SPI_SR - Status Register (RW)
 *
 * Reset value: 0x02000000U
 *
 * SR contains status and flag bits. The bits reflect the status of the module
 * and indicate the occurrence of events that can generate interrupt or DMA
 * requests. Software can clear flag bits in the SR by writing a 1 to them. Writing a 0
 * to a flag bit has no effect. This register may not be writable in Module
 * Disable mode due to the use of power saving mechanisms.
 */
typedef union _hw_spi_sr
{
    uint32_t U;
    struct _hw_spi_sr_bitfields
    {
        uint32_t POPNXTPTR : 4;        /*!< [3:0] Pop Next Pointer */
        uint32_t RXCTR : 4;            /*!< [7:4] RX FIFO Counter */
        uint32_t TXNXTPTR : 4;         /*!< [11:8] Transmit Next Pointer */
        uint32_t TXCTR : 4;            /*!< [15:12] TX FIFO Counter */
        uint32_t RESERVED0 : 1;        /*!< [16]  */
        uint32_t RFDF : 1;             /*!< [17] Receive FIFO Drain Flag */
        uint32_t RESERVED1 : 1;        /*!< [18]  */
        uint32_t RFOF : 1;             /*!< [19] Receive FIFO Overflow Flag */
        uint32_t RESERVED2 : 5;        /*!< [24:20]  */
        uint32_t TFFF : 1;             /*!< [25] Transmit FIFO Fill Flag */
        uint32_t RESERVED3 : 1;        /*!< [26]  */
        uint32_t TFUF : 1;             /*!< [27] Transmit FIFO Underflow Flag */
        uint32_t EOQF : 1;             /*!< [28] End of Queue Flag */
        uint32_t RESERVED4 : 1;        /*!< [29]  */
        uint32_t TXRXS : 1;            /*!< [30] TX and RX Status */
        uint32_t TCF : 1;              /*!< [31] Transfer Complete Flag */
    } B;
} hw_spi_sr_t;

/*!
 * @name Constants and macros for entire SPI_SR register
 */
/*@{*/
#define HW_SPI_SR_ADDR(x)        ((x) + 0x2CU)

#define HW_SPI_SR(x)             (*(__IO hw_spi_sr_t *) HW_SPI_SR_ADDR(x))
#define HW_SPI_SR_RD(x)          (HW_SPI_SR(x).U)
#define HW_SPI_SR_WR(x, v)       (HW_SPI_SR(x).U = (v))
#define HW_SPI_SR_SET(x, v)      (HW_SPI_SR_WR(x, HW_SPI_SR_RD(x) |  (v)))
#define HW_SPI_SR_CLR(x, v)      (HW_SPI_SR_WR(x, HW_SPI_SR_RD(x) & ~(v)))
#define HW_SPI_SR_TOG(x, v)      (HW_SPI_SR_WR(x, HW_SPI_SR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SPI_SR bitfields
 */

/*!
 * @name Register SPI_SR, field POPNXTPTR[3:0] (RO)
 *
 * Contains a pointer to the RX FIFO entry to be returned when the POPR is read.
 * The POPNXTPTR is updated when the POPR is read.
 */
/*@{*/
#define BP_SPI_SR_POPNXTPTR  (0U)          /*!< Bit position for SPI_SR_POPNXTPTR. */
#define BM_SPI_SR_POPNXTPTR  (0x0000000FU) /*!< Bit mask for SPI_SR_POPNXTPTR. */
#define BS_SPI_SR_POPNXTPTR  (4U)          /*!< Bit field size in bits for SPI_SR_POPNXTPTR. */

/*! @brief Read current value of the SPI_SR_POPNXTPTR field. */
#define BR_SPI_SR_POPNXTPTR(x) (HW_SPI_SR(x).B.POPNXTPTR)
/*@}*/

/*!
 * @name Register SPI_SR, field RXCTR[7:4] (RO)
 *
 * Indicates the number of entries in the RX FIFO. The RXCTR is decremented
 * every time the POPR is read. The RXCTR is incremented every time data is
 * transferred from the shift register to the RX FIFO.
 */
/*@{*/
#define BP_SPI_SR_RXCTR      (4U)          /*!< Bit position for SPI_SR_RXCTR. */
#define BM_SPI_SR_RXCTR      (0x000000F0U) /*!< Bit mask for SPI_SR_RXCTR. */
#define BS_SPI_SR_RXCTR      (4U)          /*!< Bit field size in bits for SPI_SR_RXCTR. */

/*! @brief Read current value of the SPI_SR_RXCTR field. */
#define BR_SPI_SR_RXCTR(x)   (HW_SPI_SR(x).B.RXCTR)
/*@}*/

/*!
 * @name Register SPI_SR, field TXNXTPTR[11:8] (RO)
 *
 * Indicates which TX FIFO entry is transmitted during the next transfer. The
 * TXNXTPTR field is updated every time SPI data is transferred from the TX FIFO to
 * the shift register.
 */
/*@{*/
#define BP_SPI_SR_TXNXTPTR   (8U)          /*!< Bit position for SPI_SR_TXNXTPTR. */
#define BM_SPI_SR_TXNXTPTR   (0x00000F00U) /*!< Bit mask for SPI_SR_TXNXTPTR. */
#define BS_SPI_SR_TXNXTPTR   (4U)          /*!< Bit field size in bits for SPI_SR_TXNXTPTR. */

/*! @brief Read current value of the SPI_SR_TXNXTPTR field. */
#define BR_SPI_SR_TXNXTPTR(x) (HW_SPI_SR(x).B.TXNXTPTR)
/*@}*/

/*!
 * @name Register SPI_SR, field TXCTR[15:12] (RO)
 *
 * Indicates the number of valid entries in the TX FIFO. The TXCTR is
 * incremented every time the PUSHR is written. The TXCTR is decremented every time an SPI
 * command is executed and the SPI data is transferred to the shift register.
 */
/*@{*/
#define BP_SPI_SR_TXCTR      (12U)         /*!< Bit position for SPI_SR_TXCTR. */
#define BM_SPI_SR_TXCTR      (0x0000F000U) /*!< Bit mask for SPI_SR_TXCTR. */
#define BS_SPI_SR_TXCTR      (4U)          /*!< Bit field size in bits for SPI_SR_TXCTR. */

/*! @brief Read current value of the SPI_SR_TXCTR field. */
#define BR_SPI_SR_TXCTR(x)   (HW_SPI_SR(x).B.TXCTR)
/*@}*/

/*!
 * @name Register SPI_SR, field RFDF[17] (W1C)
 *
 * Provides a method for the module to request that entries be removed from the
 * RX FIFO. The bit is set while the RX FIFO is not empty. The RFDF bit can be
 * cleared by writing 1 to it or by acknowledgement from the DMA controller when
 * the RX FIFO is empty.
 *
 * Values:
 * - 0 - RX FIFO is empty.
 * - 1 - RX FIFO is not empty.
 */
/*@{*/
#define BP_SPI_SR_RFDF       (17U)         /*!< Bit position for SPI_SR_RFDF. */
#define BM_SPI_SR_RFDF       (0x00020000U) /*!< Bit mask for SPI_SR_RFDF. */
#define BS_SPI_SR_RFDF       (1U)          /*!< Bit field size in bits for SPI_SR_RFDF. */

/*! @brief Read current value of the SPI_SR_RFDF field. */
#define BR_SPI_SR_RFDF(x)    (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_RFDF))

/*! @brief Format value for bitfield SPI_SR_RFDF. */
#define BF_SPI_SR_RFDF(v)    ((uint32_t)((uint32_t)(v) << BP_SPI_SR_RFDF) & BM_SPI_SR_RFDF)

/*! @brief Set the RFDF field to a new value. */
#define BW_SPI_SR_RFDF(x, v) (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_RFDF) = (v))
/*@}*/

/*!
 * @name Register SPI_SR, field RFOF[19] (W1C)
 *
 * Indicates an overflow condition in the RX FIFO. The field is set when the RX
 * FIFO and shift register are full and a transfer is initiated. The bit remains
 * set until it is cleared by writing a 1 to it.
 *
 * Values:
 * - 0 - No Rx FIFO overflow.
 * - 1 - Rx FIFO overflow has occurred.
 */
/*@{*/
#define BP_SPI_SR_RFOF       (19U)         /*!< Bit position for SPI_SR_RFOF. */
#define BM_SPI_SR_RFOF       (0x00080000U) /*!< Bit mask for SPI_SR_RFOF. */
#define BS_SPI_SR_RFOF       (1U)          /*!< Bit field size in bits for SPI_SR_RFOF. */

/*! @brief Read current value of the SPI_SR_RFOF field. */
#define BR_SPI_SR_RFOF(x)    (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_RFOF))

/*! @brief Format value for bitfield SPI_SR_RFOF. */
#define BF_SPI_SR_RFOF(v)    ((uint32_t)((uint32_t)(v) << BP_SPI_SR_RFOF) & BM_SPI_SR_RFOF)

/*! @brief Set the RFOF field to a new value. */
#define BW_SPI_SR_RFOF(x, v) (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_RFOF) = (v))
/*@}*/

/*!
 * @name Register SPI_SR, field TFFF[25] (W1C)
 *
 * Provides a method for the module to request more entries to be added to the
 * TX FIFO. The TFFF bit is set while the TX FIFO is not full. The TFFF bit can be
 * cleared by writing 1 to it or by acknowledgement from the DMA controller to
 * the TX FIFO full request.
 *
 * Values:
 * - 0 - TX FIFO is full.
 * - 1 - TX FIFO is not full.
 */
/*@{*/
#define BP_SPI_SR_TFFF       (25U)         /*!< Bit position for SPI_SR_TFFF. */
#define BM_SPI_SR_TFFF       (0x02000000U) /*!< Bit mask for SPI_SR_TFFF. */
#define BS_SPI_SR_TFFF       (1U)          /*!< Bit field size in bits for SPI_SR_TFFF. */

/*! @brief Read current value of the SPI_SR_TFFF field. */
#define BR_SPI_SR_TFFF(x)    (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_TFFF))

/*! @brief Format value for bitfield SPI_SR_TFFF. */
#define BF_SPI_SR_TFFF(v)    ((uint32_t)((uint32_t)(v) << BP_SPI_SR_TFFF) & BM_SPI_SR_TFFF)

/*! @brief Set the TFFF field to a new value. */
#define BW_SPI_SR_TFFF(x, v) (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_TFFF) = (v))
/*@}*/

/*!
 * @name Register SPI_SR, field TFUF[27] (W1C)
 *
 * Indicates an underflow condition in the TX FIFO. The transmit underflow
 * condition is detected only for SPI blocks operating in Slave mode and SPI
 * configuration. TFUF is set when the TX FIFO of the module operating in SPI Slave mode
 * is empty and an external SPI master initiates a transfer. The TFUF bit remains
 * set until cleared by writing 1 to it.
 *
 * Values:
 * - 0 - No TX FIFO underflow.
 * - 1 - TX FIFO underflow has occurred.
 */
/*@{*/
#define BP_SPI_SR_TFUF       (27U)         /*!< Bit position for SPI_SR_TFUF. */
#define BM_SPI_SR_TFUF       (0x08000000U) /*!< Bit mask for SPI_SR_TFUF. */
#define BS_SPI_SR_TFUF       (1U)          /*!< Bit field size in bits for SPI_SR_TFUF. */

/*! @brief Read current value of the SPI_SR_TFUF field. */
#define BR_SPI_SR_TFUF(x)    (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_TFUF))

/*! @brief Format value for bitfield SPI_SR_TFUF. */
#define BF_SPI_SR_TFUF(v)    ((uint32_t)((uint32_t)(v) << BP_SPI_SR_TFUF) & BM_SPI_SR_TFUF)

/*! @brief Set the TFUF field to a new value. */
#define BW_SPI_SR_TFUF(x, v) (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_TFUF) = (v))
/*@}*/

/*!
 * @name Register SPI_SR, field EOQF[28] (W1C)
 *
 * Indicates that the last entry in a queue has been transmitted when the module
 * is in Master mode. The EOQF bit is set when the TX FIFO entry has the EOQ bit
 * set in the command halfword and the end of the transfer is reached. The EOQF
 * bit remains set until cleared by writing a 1 to it. When the EOQF bit is set,
 * the TXRXS bit is automatically cleared.
 *
 * Values:
 * - 0 - EOQ is not set in the executing command.
 * - 1 - EOQ is set in the executing SPI command.
 */
/*@{*/
#define BP_SPI_SR_EOQF       (28U)         /*!< Bit position for SPI_SR_EOQF. */
#define BM_SPI_SR_EOQF       (0x10000000U) /*!< Bit mask for SPI_SR_EOQF. */
#define BS_SPI_SR_EOQF       (1U)          /*!< Bit field size in bits for SPI_SR_EOQF. */

/*! @brief Read current value of the SPI_SR_EOQF field. */
#define BR_SPI_SR_EOQF(x)    (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_EOQF))

/*! @brief Format value for bitfield SPI_SR_EOQF. */
#define BF_SPI_SR_EOQF(v)    ((uint32_t)((uint32_t)(v) << BP_SPI_SR_EOQF) & BM_SPI_SR_EOQF)

/*! @brief Set the EOQF field to a new value. */
#define BW_SPI_SR_EOQF(x, v) (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_EOQF) = (v))
/*@}*/

/*!
 * @name Register SPI_SR, field TXRXS[30] (W1C)
 *
 * Reflects the run status of the module.
 *
 * Values:
 * - 0 - Transmit and receive operations are disabled (The module is in Stopped
 *     state).
 * - 1 - Transmit and receive operations are enabled (The module is in Running
 *     state).
 */
/*@{*/
#define BP_SPI_SR_TXRXS      (30U)         /*!< Bit position for SPI_SR_TXRXS. */
#define BM_SPI_SR_TXRXS      (0x40000000U) /*!< Bit mask for SPI_SR_TXRXS. */
#define BS_SPI_SR_TXRXS      (1U)          /*!< Bit field size in bits for SPI_SR_TXRXS. */

/*! @brief Read current value of the SPI_SR_TXRXS field. */
#define BR_SPI_SR_TXRXS(x)   (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_TXRXS))

/*! @brief Format value for bitfield SPI_SR_TXRXS. */
#define BF_SPI_SR_TXRXS(v)   ((uint32_t)((uint32_t)(v) << BP_SPI_SR_TXRXS) & BM_SPI_SR_TXRXS)

/*! @brief Set the TXRXS field to a new value. */
#define BW_SPI_SR_TXRXS(x, v) (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_TXRXS) = (v))
/*@}*/

/*!
 * @name Register SPI_SR, field TCF[31] (W1C)
 *
 * Indicates that all bits in a frame have been shifted out. TCF remains set
 * until it is cleared by writing a 1 to it.
 *
 * Values:
 * - 0 - Transfer not complete.
 * - 1 - Transfer complete.
 */
/*@{*/
#define BP_SPI_SR_TCF        (31U)         /*!< Bit position for SPI_SR_TCF. */
#define BM_SPI_SR_TCF        (0x80000000U) /*!< Bit mask for SPI_SR_TCF. */
#define BS_SPI_SR_TCF        (1U)          /*!< Bit field size in bits for SPI_SR_TCF. */

/*! @brief Read current value of the SPI_SR_TCF field. */
#define BR_SPI_SR_TCF(x)     (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_TCF))

/*! @brief Format value for bitfield SPI_SR_TCF. */
#define BF_SPI_SR_TCF(v)     ((uint32_t)((uint32_t)(v) << BP_SPI_SR_TCF) & BM_SPI_SR_TCF)

/*! @brief Set the TCF field to a new value. */
#define BW_SPI_SR_TCF(x, v)  (BITBAND_ACCESS32(HW_SPI_SR_ADDR(x), BP_SPI_SR_TCF) = (v))
/*@}*/

/*******************************************************************************
 * HW_SPI_RSER - DMA/Interrupt Request Select and Enable Register
 ******************************************************************************/

/*!
 * @brief HW_SPI_RSER - DMA/Interrupt Request Select and Enable Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * RSER controls DMA and interrupt requests. Do not write to the RSER while the
 * module is in the Running state.
 */
typedef union _hw_spi_rser
{
    uint32_t U;
    struct _hw_spi_rser_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t RFDF_DIRS : 1;        /*!< [16] Receive FIFO Drain DMA or Interrupt
                                        * Request Select */
        uint32_t RFDF_RE : 1;          /*!< [17] Receive FIFO Drain Request Enable */
        uint32_t RESERVED1 : 1;        /*!< [18]  */
        uint32_t RFOF_RE : 1;          /*!< [19] Receive FIFO Overflow Request Enable
                                        * */
        uint32_t RESERVED2 : 4;        /*!< [23:20]  */
        uint32_t TFFF_DIRS : 1;        /*!< [24] Transmit FIFO Fill DMA or Interrupt
                                        * Request Select */
        uint32_t TFFF_RE : 1;          /*!< [25] Transmit FIFO Fill Request Enable */
        uint32_t RESERVED3 : 1;        /*!< [26]  */
        uint32_t TFUF_RE : 1;          /*!< [27] Transmit FIFO Underflow Request
                                        * Enable */
        uint32_t EOQF_RE : 1;          /*!< [28] Finished Request Enable */
        uint32_t RESERVED4 : 2;        /*!< [30:29]  */
        uint32_t TCF_RE : 1;           /*!< [31] Transmission Complete Request Enable */
    } B;
} hw_spi_rser_t;

/*!
 * @name Constants and macros for entire SPI_RSER register
 */
/*@{*/
#define HW_SPI_RSER_ADDR(x)      ((x) + 0x30U)

#define HW_SPI_RSER(x)           (*(__IO hw_spi_rser_t *) HW_SPI_RSER_ADDR(x))
#define HW_SPI_RSER_RD(x)        (HW_SPI_RSER(x).U)
#define HW_SPI_RSER_WR(x, v)     (HW_SPI_RSER(x).U = (v))
#define HW_SPI_RSER_SET(x, v)    (HW_SPI_RSER_WR(x, HW_SPI_RSER_RD(x) |  (v)))
#define HW_SPI_RSER_CLR(x, v)    (HW_SPI_RSER_WR(x, HW_SPI_RSER_RD(x) & ~(v)))
#define HW_SPI_RSER_TOG(x, v)    (HW_SPI_RSER_WR(x, HW_SPI_RSER_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SPI_RSER bitfields
 */

/*!
 * @name Register SPI_RSER, field RFDF_DIRS[16] (RW)
 *
 * Selects between generating a DMA request or an interrupt request. When the
 * RFDF flag bit in the SR is set, and the RFDF_RE bit in the RSER is set, the
 * RFDF_DIRS bit selects between generating an interrupt request or a DMA request.
 *
 * Values:
 * - 0 - Interrupt request.
 * - 1 - DMA request.
 */
/*@{*/
#define BP_SPI_RSER_RFDF_DIRS (16U)        /*!< Bit position for SPI_RSER_RFDF_DIRS. */
#define BM_SPI_RSER_RFDF_DIRS (0x00010000U) /*!< Bit mask for SPI_RSER_RFDF_DIRS. */
#define BS_SPI_RSER_RFDF_DIRS (1U)         /*!< Bit field size in bits for SPI_RSER_RFDF_DIRS. */

/*! @brief Read current value of the SPI_RSER_RFDF_DIRS field. */
#define BR_SPI_RSER_RFDF_DIRS(x) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_RFDF_DIRS))

/*! @brief Format value for bitfield SPI_RSER_RFDF_DIRS. */
#define BF_SPI_RSER_RFDF_DIRS(v) ((uint32_t)((uint32_t)(v) << BP_SPI_RSER_RFDF_DIRS) & BM_SPI_RSER_RFDF_DIRS)

/*! @brief Set the RFDF_DIRS field to a new value. */
#define BW_SPI_RSER_RFDF_DIRS(x, v) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_RFDF_DIRS) = (v))
/*@}*/

/*!
 * @name Register SPI_RSER, field RFDF_RE[17] (RW)
 *
 * Enables the RFDF flag in the SR to generate a request. The RFDF_DIRS bit
 * selects between generating an interrupt request or a DMA request.
 *
 * Values:
 * - 0 - RFDF interrupt or DMA requests are disabled.
 * - 1 - RFDF interrupt or DMA requests are enabled.
 */
/*@{*/
#define BP_SPI_RSER_RFDF_RE  (17U)         /*!< Bit position for SPI_RSER_RFDF_RE. */
#define BM_SPI_RSER_RFDF_RE  (0x00020000U) /*!< Bit mask for SPI_RSER_RFDF_RE. */
#define BS_SPI_RSER_RFDF_RE  (1U)          /*!< Bit field size in bits for SPI_RSER_RFDF_RE. */

/*! @brief Read current value of the SPI_RSER_RFDF_RE field. */
#define BR_SPI_RSER_RFDF_RE(x) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_RFDF_RE))

/*! @brief Format value for bitfield SPI_RSER_RFDF_RE. */
#define BF_SPI_RSER_RFDF_RE(v) ((uint32_t)((uint32_t)(v) << BP_SPI_RSER_RFDF_RE) & BM_SPI_RSER_RFDF_RE)

/*! @brief Set the RFDF_RE field to a new value. */
#define BW_SPI_RSER_RFDF_RE(x, v) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_RFDF_RE) = (v))
/*@}*/

/*!
 * @name Register SPI_RSER, field RFOF_RE[19] (RW)
 *
 * Enables the RFOF flag in the SR to generate an interrupt request.
 *
 * Values:
 * - 0 - RFOF interrupt requests are disabled.
 * - 1 - RFOF interrupt requests are enabled.
 */
/*@{*/
#define BP_SPI_RSER_RFOF_RE  (19U)         /*!< Bit position for SPI_RSER_RFOF_RE. */
#define BM_SPI_RSER_RFOF_RE  (0x00080000U) /*!< Bit mask for SPI_RSER_RFOF_RE. */
#define BS_SPI_RSER_RFOF_RE  (1U)          /*!< Bit field size in bits for SPI_RSER_RFOF_RE. */

/*! @brief Read current value of the SPI_RSER_RFOF_RE field. */
#define BR_SPI_RSER_RFOF_RE(x) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_RFOF_RE))

/*! @brief Format value for bitfield SPI_RSER_RFOF_RE. */
#define BF_SPI_RSER_RFOF_RE(v) ((uint32_t)((uint32_t)(v) << BP_SPI_RSER_RFOF_RE) & BM_SPI_RSER_RFOF_RE)

/*! @brief Set the RFOF_RE field to a new value. */
#define BW_SPI_RSER_RFOF_RE(x, v) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_RFOF_RE) = (v))
/*@}*/

/*!
 * @name Register SPI_RSER, field TFFF_DIRS[24] (RW)
 *
 * Selects between generating a DMA request or an interrupt request. When
 * SR[TFFF] and RSER[TFFF_RE] are set, this field selects between generating an
 * interrupt request or a DMA request.
 *
 * Values:
 * - 0 - TFFF flag generates interrupt requests.
 * - 1 - TFFF flag generates DMA requests.
 */
/*@{*/
#define BP_SPI_RSER_TFFF_DIRS (24U)        /*!< Bit position for SPI_RSER_TFFF_DIRS. */
#define BM_SPI_RSER_TFFF_DIRS (0x01000000U) /*!< Bit mask for SPI_RSER_TFFF_DIRS. */
#define BS_SPI_RSER_TFFF_DIRS (1U)         /*!< Bit field size in bits for SPI_RSER_TFFF_DIRS. */

/*! @brief Read current value of the SPI_RSER_TFFF_DIRS field. */
#define BR_SPI_RSER_TFFF_DIRS(x) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_TFFF_DIRS))

/*! @brief Format value for bitfield SPI_RSER_TFFF_DIRS. */
#define BF_SPI_RSER_TFFF_DIRS(v) ((uint32_t)((uint32_t)(v) << BP_SPI_RSER_TFFF_DIRS) & BM_SPI_RSER_TFFF_DIRS)

/*! @brief Set the TFFF_DIRS field to a new value. */
#define BW_SPI_RSER_TFFF_DIRS(x, v) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_TFFF_DIRS) = (v))
/*@}*/

/*!
 * @name Register SPI_RSER, field TFFF_RE[25] (RW)
 *
 * Enables the TFFF flag in the SR to generate a request. The TFFF_DIRS bit
 * selects between generating an interrupt request or a DMA request.
 *
 * Values:
 * - 0 - TFFF interrupts or DMA requests are disabled.
 * - 1 - TFFF interrupts or DMA requests are enabled.
 */
/*@{*/
#define BP_SPI_RSER_TFFF_RE  (25U)         /*!< Bit position for SPI_RSER_TFFF_RE. */
#define BM_SPI_RSER_TFFF_RE  (0x02000000U) /*!< Bit mask for SPI_RSER_TFFF_RE. */
#define BS_SPI_RSER_TFFF_RE  (1U)          /*!< Bit field size in bits for SPI_RSER_TFFF_RE. */

/*! @brief Read current value of the SPI_RSER_TFFF_RE field. */
#define BR_SPI_RSER_TFFF_RE(x) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_TFFF_RE))

/*! @brief Format value for bitfield SPI_RSER_TFFF_RE. */
#define BF_SPI_RSER_TFFF_RE(v) ((uint32_t)((uint32_t)(v) << BP_SPI_RSER_TFFF_RE) & BM_SPI_RSER_TFFF_RE)

/*! @brief Set the TFFF_RE field to a new value. */
#define BW_SPI_RSER_TFFF_RE(x, v) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_TFFF_RE) = (v))
/*@}*/

/*!
 * @name Register SPI_RSER, field TFUF_RE[27] (RW)
 *
 * Enables the TFUF flag in the SR to generate an interrupt request.
 *
 * Values:
 * - 0 - TFUF interrupt requests are disabled.
 * - 1 - TFUF interrupt requests are enabled.
 */
/*@{*/
#define BP_SPI_RSER_TFUF_RE  (27U)         /*!< Bit position for SPI_RSER_TFUF_RE. */
#define BM_SPI_RSER_TFUF_RE  (0x08000000U) /*!< Bit mask for SPI_RSER_TFUF_RE. */
#define BS_SPI_RSER_TFUF_RE  (1U)          /*!< Bit field size in bits for SPI_RSER_TFUF_RE. */

/*! @brief Read current value of the SPI_RSER_TFUF_RE field. */
#define BR_SPI_RSER_TFUF_RE(x) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_TFUF_RE))

/*! @brief Format value for bitfield SPI_RSER_TFUF_RE. */
#define BF_SPI_RSER_TFUF_RE(v) ((uint32_t)((uint32_t)(v) << BP_SPI_RSER_TFUF_RE) & BM_SPI_RSER_TFUF_RE)

/*! @brief Set the TFUF_RE field to a new value. */
#define BW_SPI_RSER_TFUF_RE(x, v) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_TFUF_RE) = (v))
/*@}*/

/*!
 * @name Register SPI_RSER, field EOQF_RE[28] (RW)
 *
 * Enables the EOQF flag in the SR to generate an interrupt request.
 *
 * Values:
 * - 0 - EOQF interrupt requests are disabled.
 * - 1 - EOQF interrupt requests are enabled.
 */
/*@{*/
#define BP_SPI_RSER_EOQF_RE  (28U)         /*!< Bit position for SPI_RSER_EOQF_RE. */
#define BM_SPI_RSER_EOQF_RE  (0x10000000U) /*!< Bit mask for SPI_RSER_EOQF_RE. */
#define BS_SPI_RSER_EOQF_RE  (1U)          /*!< Bit field size in bits for SPI_RSER_EOQF_RE. */

/*! @brief Read current value of the SPI_RSER_EOQF_RE field. */
#define BR_SPI_RSER_EOQF_RE(x) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_EOQF_RE))

/*! @brief Format value for bitfield SPI_RSER_EOQF_RE. */
#define BF_SPI_RSER_EOQF_RE(v) ((uint32_t)((uint32_t)(v) << BP_SPI_RSER_EOQF_RE) & BM_SPI_RSER_EOQF_RE)

/*! @brief Set the EOQF_RE field to a new value. */
#define BW_SPI_RSER_EOQF_RE(x, v) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_EOQF_RE) = (v))
/*@}*/

/*!
 * @name Register SPI_RSER, field TCF_RE[31] (RW)
 *
 * Enables TCF flag in the SR to generate an interrupt request.
 *
 * Values:
 * - 0 - TCF interrupt requests are disabled.
 * - 1 - TCF interrupt requests are enabled.
 */
/*@{*/
#define BP_SPI_RSER_TCF_RE   (31U)         /*!< Bit position for SPI_RSER_TCF_RE. */
#define BM_SPI_RSER_TCF_RE   (0x80000000U) /*!< Bit mask for SPI_RSER_TCF_RE. */
#define BS_SPI_RSER_TCF_RE   (1U)          /*!< Bit field size in bits for SPI_RSER_TCF_RE. */

/*! @brief Read current value of the SPI_RSER_TCF_RE field. */
#define BR_SPI_RSER_TCF_RE(x) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_TCF_RE))

/*! @brief Format value for bitfield SPI_RSER_TCF_RE. */
#define BF_SPI_RSER_TCF_RE(v) ((uint32_t)((uint32_t)(v) << BP_SPI_RSER_TCF_RE) & BM_SPI_RSER_TCF_RE)

/*! @brief Set the TCF_RE field to a new value. */
#define BW_SPI_RSER_TCF_RE(x, v) (BITBAND_ACCESS32(HW_SPI_RSER_ADDR(x), BP_SPI_RSER_TCF_RE) = (v))
/*@}*/

/*******************************************************************************
 * HW_SPI_PUSHR - PUSH TX FIFO Register In Master Mode
 ******************************************************************************/

/*!
 * @brief HW_SPI_PUSHR - PUSH TX FIFO Register In Master Mode (RW)
 *
 * Reset value: 0x00000000U
 *
 * Specifies data to be transferred to the TX FIFO. An 8- or 16-bit write access
 * transfers all 32 bits to the TX FIFO. In Master mode, the register transfers
 * 16 bits of data and 16 bits of command information. In Slave mode, all 32 bits
 * can be used as data, supporting up to 32-bit frame operation. A read access
 * of PUSHR returns the topmost TX FIFO entry. When the module is disabled,
 * writing to this register does not update the FIFO. Therefore, any reads performed
 * while the module is disabled return the last PUSHR write performed while the
 * module was still enabled.
 */
typedef union _hw_spi_pushr
{
    uint32_t U;
    struct _hw_spi_pushr_bitfields
    {
        uint32_t TXDATA : 16;          /*!< [15:0] Transmit Data */
        uint32_t PCS : 6;              /*!< [21:16]  */
        uint32_t RESERVED0 : 4;        /*!< [25:22]  */
        uint32_t CTCNT : 1;            /*!< [26] Clear Transfer Counter */
        uint32_t EOQ : 1;              /*!< [27] End Of Queue */
        uint32_t CTAS : 3;             /*!< [30:28] Clock and Transfer Attributes Select
                                        * */
        uint32_t CONT : 1;             /*!< [31] Continuous Peripheral Chip Select Enable
                                        * */
    } B;
} hw_spi_pushr_t;

/*!
 * @name Constants and macros for entire SPI_PUSHR register
 */
/*@{*/
#define HW_SPI_PUSHR_ADDR(x)     ((x) + 0x34U)

#define HW_SPI_PUSHR(x)          (*(__IO hw_spi_pushr_t *) HW_SPI_PUSHR_ADDR(x))
#define HW_SPI_PUSHR_RD(x)       (HW_SPI_PUSHR(x).U)
#define HW_SPI_PUSHR_WR(x, v)    (HW_SPI_PUSHR(x).U = (v))
#define HW_SPI_PUSHR_SET(x, v)   (HW_SPI_PUSHR_WR(x, HW_SPI_PUSHR_RD(x) |  (v)))
#define HW_SPI_PUSHR_CLR(x, v)   (HW_SPI_PUSHR_WR(x, HW_SPI_PUSHR_RD(x) & ~(v)))
#define HW_SPI_PUSHR_TOG(x, v)   (HW_SPI_PUSHR_WR(x, HW_SPI_PUSHR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SPI_PUSHR bitfields
 */

/*!
 * @name Register SPI_PUSHR, field TXDATA[15:0] (RW)
 *
 * Holds SPI data to be transferred according to the associated SPI command.
 */
/*@{*/
#define BP_SPI_PUSHR_TXDATA  (0U)          /*!< Bit position for SPI_PUSHR_TXDATA. */
#define BM_SPI_PUSHR_TXDATA  (0x0000FFFFU) /*!< Bit mask for SPI_PUSHR_TXDATA. */
#define BS_SPI_PUSHR_TXDATA  (16U)         /*!< Bit field size in bits for SPI_PUSHR_TXDATA. */

/*! @brief Read current value of the SPI_PUSHR_TXDATA field. */
#define BR_SPI_PUSHR_TXDATA(x) (HW_SPI_PUSHR(x).B.TXDATA)

/*! @brief Format value for bitfield SPI_PUSHR_TXDATA. */
#define BF_SPI_PUSHR_TXDATA(v) ((uint32_t)((uint32_t)(v) << BP_SPI_PUSHR_TXDATA) & BM_SPI_PUSHR_TXDATA)

/*! @brief Set the TXDATA field to a new value. */
#define BW_SPI_PUSHR_TXDATA(x, v) (HW_SPI_PUSHR_WR(x, (HW_SPI_PUSHR_RD(x) & ~BM_SPI_PUSHR_TXDATA) | BF_SPI_PUSHR_TXDATA(v)))
/*@}*/

/*!
 * @name Register SPI_PUSHR, field PCS[21:16] (RW)
 *
 * Select which PCS signals are to be asserted for the transfer. Refer to the
 * chip configuration details for the number of PCS signals used in this MCU.
 *
 * Values:
 * - 0 - Negate the PCS[x] signal.
 * - 1 - Assert the PCS[x] signal.
 */
/*@{*/
#define BP_SPI_PUSHR_PCS     (16U)         /*!< Bit position for SPI_PUSHR_PCS. */
#define BM_SPI_PUSHR_PCS     (0x003F0000U) /*!< Bit mask for SPI_PUSHR_PCS. */
#define BS_SPI_PUSHR_PCS     (6U)          /*!< Bit field size in bits for SPI_PUSHR_PCS. */

/*! @brief Read current value of the SPI_PUSHR_PCS field. */
#define BR_SPI_PUSHR_PCS(x)  (HW_SPI_PUSHR(x).B.PCS)

/*! @brief Format value for bitfield SPI_PUSHR_PCS. */
#define BF_SPI_PUSHR_PCS(v)  ((uint32_t)((uint32_t)(v) << BP_SPI_PUSHR_PCS) & BM_SPI_PUSHR_PCS)

/*! @brief Set the PCS field to a new value. */
#define BW_SPI_PUSHR_PCS(x, v) (HW_SPI_PUSHR_WR(x, (HW_SPI_PUSHR_RD(x) & ~BM_SPI_PUSHR_PCS) | BF_SPI_PUSHR_PCS(v)))
/*@}*/

/*!
 * @name Register SPI_PUSHR, field CTCNT[26] (RW)
 *
 * Clears the TCNT field in the TCR register. The TCNT field is cleared before
 * the module starts transmitting the current SPI frame.
 *
 * Values:
 * - 0 - Do not clear the TCR[TCNT] field.
 * - 1 - Clear the TCR[TCNT] field.
 */
/*@{*/
#define BP_SPI_PUSHR_CTCNT   (26U)         /*!< Bit position for SPI_PUSHR_CTCNT. */
#define BM_SPI_PUSHR_CTCNT   (0x04000000U) /*!< Bit mask for SPI_PUSHR_CTCNT. */
#define BS_SPI_PUSHR_CTCNT   (1U)          /*!< Bit field size in bits for SPI_PUSHR_CTCNT. */

/*! @brief Read current value of the SPI_PUSHR_CTCNT field. */
#define BR_SPI_PUSHR_CTCNT(x) (BITBAND_ACCESS32(HW_SPI_PUSHR_ADDR(x), BP_SPI_PUSHR_CTCNT))

/*! @brief Format value for bitfield SPI_PUSHR_CTCNT. */
#define BF_SPI_PUSHR_CTCNT(v) ((uint32_t)((uint32_t)(v) << BP_SPI_PUSHR_CTCNT) & BM_SPI_PUSHR_CTCNT)

/*! @brief Set the CTCNT field to a new value. */
#define BW_SPI_PUSHR_CTCNT(x, v) (BITBAND_ACCESS32(HW_SPI_PUSHR_ADDR(x), BP_SPI_PUSHR_CTCNT) = (v))
/*@}*/

/*!
 * @name Register SPI_PUSHR, field EOQ[27] (RW)
 *
 * Host software uses this bit to signal to the module that the current SPI
 * transfer is the last in a queue. At the end of the transfer, the EOQF bit in the
 * SR is set.
 *
 * Values:
 * - 0 - The SPI data is not the last data to transfer.
 * - 1 - The SPI data is the last data to transfer.
 */
/*@{*/
#define BP_SPI_PUSHR_EOQ     (27U)         /*!< Bit position for SPI_PUSHR_EOQ. */
#define BM_SPI_PUSHR_EOQ     (0x08000000U) /*!< Bit mask for SPI_PUSHR_EOQ. */
#define BS_SPI_PUSHR_EOQ     (1U)          /*!< Bit field size in bits for SPI_PUSHR_EOQ. */

/*! @brief Read current value of the SPI_PUSHR_EOQ field. */
#define BR_SPI_PUSHR_EOQ(x)  (BITBAND_ACCESS32(HW_SPI_PUSHR_ADDR(x), BP_SPI_PUSHR_EOQ))

/*! @brief Format value for bitfield SPI_PUSHR_EOQ. */
#define BF_SPI_PUSHR_EOQ(v)  ((uint32_t)((uint32_t)(v) << BP_SPI_PUSHR_EOQ) & BM_SPI_PUSHR_EOQ)

/*! @brief Set the EOQ field to a new value. */
#define BW_SPI_PUSHR_EOQ(x, v) (BITBAND_ACCESS32(HW_SPI_PUSHR_ADDR(x), BP_SPI_PUSHR_EOQ) = (v))
/*@}*/

/*!
 * @name Register SPI_PUSHR, field CTAS[30:28] (RW)
 *
 * Selects which CTAR to use in master mode to specify the transfer attributes
 * for the associated SPI frame. In SPI Slave mode, CTAR0 is used. See the chip
 * configuration details to determine how many CTARs this device has. You should
 * not program a value in this field for a register that is not present.
 *
 * Values:
 * - 000 - CTAR0
 * - 001 - CTAR1
 * - 010 - Reserved
 * - 011 - Reserved
 * - 100 - Reserved
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_SPI_PUSHR_CTAS    (28U)         /*!< Bit position for SPI_PUSHR_CTAS. */
#define BM_SPI_PUSHR_CTAS    (0x70000000U) /*!< Bit mask for SPI_PUSHR_CTAS. */
#define BS_SPI_PUSHR_CTAS    (3U)          /*!< Bit field size in bits for SPI_PUSHR_CTAS. */

/*! @brief Read current value of the SPI_PUSHR_CTAS field. */
#define BR_SPI_PUSHR_CTAS(x) (HW_SPI_PUSHR(x).B.CTAS)

/*! @brief Format value for bitfield SPI_PUSHR_CTAS. */
#define BF_SPI_PUSHR_CTAS(v) ((uint32_t)((uint32_t)(v) << BP_SPI_PUSHR_CTAS) & BM_SPI_PUSHR_CTAS)

/*! @brief Set the CTAS field to a new value. */
#define BW_SPI_PUSHR_CTAS(x, v) (HW_SPI_PUSHR_WR(x, (HW_SPI_PUSHR_RD(x) & ~BM_SPI_PUSHR_CTAS) | BF_SPI_PUSHR_CTAS(v)))
/*@}*/

/*!
 * @name Register SPI_PUSHR, field CONT[31] (RW)
 *
 * Selects a continuous selection format. The bit is used in SPI Master mode.
 * The bit enables the selected PCS signals to remain asserted between transfers.
 *
 * Values:
 * - 0 - Return PCSn signals to their inactive state between transfers.
 * - 1 - Keep PCSn signals asserted between transfers.
 */
/*@{*/
#define BP_SPI_PUSHR_CONT    (31U)         /*!< Bit position for SPI_PUSHR_CONT. */
#define BM_SPI_PUSHR_CONT    (0x80000000U) /*!< Bit mask for SPI_PUSHR_CONT. */
#define BS_SPI_PUSHR_CONT    (1U)          /*!< Bit field size in bits for SPI_PUSHR_CONT. */

/*! @brief Read current value of the SPI_PUSHR_CONT field. */
#define BR_SPI_PUSHR_CONT(x) (BITBAND_ACCESS32(HW_SPI_PUSHR_ADDR(x), BP_SPI_PUSHR_CONT))

/*! @brief Format value for bitfield SPI_PUSHR_CONT. */
#define BF_SPI_PUSHR_CONT(v) ((uint32_t)((uint32_t)(v) << BP_SPI_PUSHR_CONT) & BM_SPI_PUSHR_CONT)

/*! @brief Set the CONT field to a new value. */
#define BW_SPI_PUSHR_CONT(x, v) (BITBAND_ACCESS32(HW_SPI_PUSHR_ADDR(x), BP_SPI_PUSHR_CONT) = (v))
/*@}*/
/*******************************************************************************
 * HW_SPI_PUSHR_SLAVE - PUSH TX FIFO Register In Slave Mode
 ******************************************************************************/

/*!
 * @brief HW_SPI_PUSHR_SLAVE - PUSH TX FIFO Register In Slave Mode (RW)
 *
 * Reset value: 0x00000000U
 *
 * Specifies data to be transferred to the TX FIFO. An 8- or 16-bit write access
 * to PUSHR transfers all 32 bits to the TX FIFO. In master mode, the register
 * transfers 16 bits of data and 16 bits of command information to the TX FIFO. In
 * slave mode, all 32 register bits can be used as data, supporting up to 32-bit
 * SPI Frame operation.
 */
typedef union _hw_spi_pushr_slave
{
    uint32_t U;
    struct _hw_spi_pushr_slave_bitfields
    {
        uint32_t TXDATA : 32;          /*!< [31:0] Transmit Data */
    } B;
} hw_spi_pushr_slave_t;

/*!
 * @name Constants and macros for entire SPI_PUSHR_SLAVE register
 */
/*@{*/
#define HW_SPI_PUSHR_SLAVE_ADDR(x) ((x) + 0x34U)

#define HW_SPI_PUSHR_SLAVE(x)    (*(__IO hw_spi_pushr_slave_t *) HW_SPI_PUSHR_SLAVE_ADDR(x))
#define HW_SPI_PUSHR_SLAVE_RD(x) (HW_SPI_PUSHR_SLAVE(x).U)
#define HW_SPI_PUSHR_SLAVE_WR(x, v) (HW_SPI_PUSHR_SLAVE(x).U = (v))
#define HW_SPI_PUSHR_SLAVE_SET(x, v) (HW_SPI_PUSHR_SLAVE_WR(x, HW_SPI_PUSHR_SLAVE_RD(x) |  (v)))
#define HW_SPI_PUSHR_SLAVE_CLR(x, v) (HW_SPI_PUSHR_SLAVE_WR(x, HW_SPI_PUSHR_SLAVE_RD(x) & ~(v)))
#define HW_SPI_PUSHR_SLAVE_TOG(x, v) (HW_SPI_PUSHR_SLAVE_WR(x, HW_SPI_PUSHR_SLAVE_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SPI_PUSHR_SLAVE bitfields
 */

/*!
 * @name Register SPI_PUSHR_SLAVE, field TXDATA[31:0] (RW)
 *
 * Holds SPI data to be transferred according to the associated SPI command.
 */
/*@{*/
#define BP_SPI_PUSHR_SLAVE_TXDATA (0U)     /*!< Bit position for SPI_PUSHR_SLAVE_TXDATA. */
#define BM_SPI_PUSHR_SLAVE_TXDATA (0xFFFFFFFFU) /*!< Bit mask for SPI_PUSHR_SLAVE_TXDATA. */
#define BS_SPI_PUSHR_SLAVE_TXDATA (32U)    /*!< Bit field size in bits for SPI_PUSHR_SLAVE_TXDATA. */

/*! @brief Read current value of the SPI_PUSHR_SLAVE_TXDATA field. */
#define BR_SPI_PUSHR_SLAVE_TXDATA(x) (HW_SPI_PUSHR_SLAVE(x).U)

/*! @brief Format value for bitfield SPI_PUSHR_SLAVE_TXDATA. */
#define BF_SPI_PUSHR_SLAVE_TXDATA(v) ((uint32_t)((uint32_t)(v) << BP_SPI_PUSHR_SLAVE_TXDATA) & BM_SPI_PUSHR_SLAVE_TXDATA)

/*! @brief Set the TXDATA field to a new value. */
#define BW_SPI_PUSHR_SLAVE_TXDATA(x, v) (HW_SPI_PUSHR_SLAVE_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_SPI_POPR - POP RX FIFO Register
 ******************************************************************************/

/*!
 * @brief HW_SPI_POPR - POP RX FIFO Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * POPR is used to read the RX FIFO. Eight- or sixteen-bit read accesses to the
 * POPR have the same effect on the RX FIFO as 32-bit read accesses. A write to
 * this register will generate a Transfer Error.
 */
typedef union _hw_spi_popr
{
    uint32_t U;
    struct _hw_spi_popr_bitfields
    {
        uint32_t RXDATA : 32;          /*!< [31:0] Received Data */
    } B;
} hw_spi_popr_t;

/*!
 * @name Constants and macros for entire SPI_POPR register
 */
/*@{*/
#define HW_SPI_POPR_ADDR(x)      ((x) + 0x38U)

#define HW_SPI_POPR(x)           (*(__I hw_spi_popr_t *) HW_SPI_POPR_ADDR(x))
#define HW_SPI_POPR_RD(x)        (HW_SPI_POPR(x).U)
/*@}*/

/*
 * Constants & macros for individual SPI_POPR bitfields
 */

/*!
 * @name Register SPI_POPR, field RXDATA[31:0] (RO)
 *
 * Contains the SPI data from the RX FIFO entry to which the Pop Next Data
 * Pointer points.
 */
/*@{*/
#define BP_SPI_POPR_RXDATA   (0U)          /*!< Bit position for SPI_POPR_RXDATA. */
#define BM_SPI_POPR_RXDATA   (0xFFFFFFFFU) /*!< Bit mask for SPI_POPR_RXDATA. */
#define BS_SPI_POPR_RXDATA   (32U)         /*!< Bit field size in bits for SPI_POPR_RXDATA. */

/*! @brief Read current value of the SPI_POPR_RXDATA field. */
#define BR_SPI_POPR_RXDATA(x) (HW_SPI_POPR(x).U)
/*@}*/

/*******************************************************************************
 * HW_SPI_TXFRn - Transmit FIFO Registers
 ******************************************************************************/

/*!
 * @brief HW_SPI_TXFRn - Transmit FIFO Registers (RO)
 *
 * Reset value: 0x00000000U
 *
 * TXFRn registers provide visibility into the TX FIFO for debugging purposes.
 * Each register is an entry in the TX FIFO. The registers are read-only and
 * cannot be modified. Reading the TXFRx registers does not alter the state of the TX
 * FIFO.
 */
typedef union _hw_spi_txfrn
{
    uint32_t U;
    struct _hw_spi_txfrn_bitfields
    {
        uint32_t TXDATA : 16;          /*!< [15:0] Transmit Data */
        uint32_t TXCMD_TXDATA : 16;    /*!< [31:16] Transmit Command or Transmit
                                        * Data */
    } B;
} hw_spi_txfrn_t;

/*!
 * @name Constants and macros for entire SPI_TXFRn register
 */
/*@{*/
#define HW_SPI_TXFRn_COUNT (4U)

#define HW_SPI_TXFRn_ADDR(x, n)  ((x) + 0x3CU + (0x4U * (n)))

#define HW_SPI_TXFRn(x, n)       (*(__I hw_spi_txfrn_t *) HW_SPI_TXFRn_ADDR(x, n))
#define HW_SPI_TXFRn_RD(x, n)    (HW_SPI_TXFRn(x, n).U)
/*@}*/

/*
 * Constants & macros for individual SPI_TXFRn bitfields
 */

/*!
 * @name Register SPI_TXFRn, field TXDATA[15:0] (RO)
 *
 * Contains the SPI data to be shifted out.
 */
/*@{*/
#define BP_SPI_TXFRn_TXDATA  (0U)          /*!< Bit position for SPI_TXFRn_TXDATA. */
#define BM_SPI_TXFRn_TXDATA  (0x0000FFFFU) /*!< Bit mask for SPI_TXFRn_TXDATA. */
#define BS_SPI_TXFRn_TXDATA  (16U)         /*!< Bit field size in bits for SPI_TXFRn_TXDATA. */

/*! @brief Read current value of the SPI_TXFRn_TXDATA field. */
#define BR_SPI_TXFRn_TXDATA(x, n) (HW_SPI_TXFRn(x, n).B.TXDATA)
/*@}*/

/*!
 * @name Register SPI_TXFRn, field TXCMD_TXDATA[31:16] (RO)
 *
 * In Master mode the TXCMD field contains the command that sets the transfer
 * attributes for the SPI data. In Slave mode, the TXDATA contains 16 MSB bits of
 * the SPI data to be shifted out.
 */
/*@{*/
#define BP_SPI_TXFRn_TXCMD_TXDATA (16U)    /*!< Bit position for SPI_TXFRn_TXCMD_TXDATA. */
#define BM_SPI_TXFRn_TXCMD_TXDATA (0xFFFF0000U) /*!< Bit mask for SPI_TXFRn_TXCMD_TXDATA. */
#define BS_SPI_TXFRn_TXCMD_TXDATA (16U)    /*!< Bit field size in bits for SPI_TXFRn_TXCMD_TXDATA. */

/*! @brief Read current value of the SPI_TXFRn_TXCMD_TXDATA field. */
#define BR_SPI_TXFRn_TXCMD_TXDATA(x, n) (HW_SPI_TXFRn(x, n).B.TXCMD_TXDATA)
/*@}*/

/*******************************************************************************
 * HW_SPI_RXFRn - Receive FIFO Registers
 ******************************************************************************/

/*!
 * @brief HW_SPI_RXFRn - Receive FIFO Registers (RO)
 *
 * Reset value: 0x00000000U
 *
 * RXFRn provide visibility into the RX FIFO for debugging purposes. Each
 * register is an entry in the RX FIFO. The RXFR registers are read-only. Reading the
 * RXFRx registers does not alter the state of the RX FIFO.
 */
typedef union _hw_spi_rxfrn
{
    uint32_t U;
    struct _hw_spi_rxfrn_bitfields
    {
        uint32_t RXDATA : 32;          /*!< [31:0] Receive Data */
    } B;
} hw_spi_rxfrn_t;

/*!
 * @name Constants and macros for entire SPI_RXFRn register
 */
/*@{*/
#define HW_SPI_RXFRn_COUNT (4U)

#define HW_SPI_RXFRn_ADDR(x, n)  ((x) + 0x7CU + (0x4U * (n)))

#define HW_SPI_RXFRn(x, n)       (*(__I hw_spi_rxfrn_t *) HW_SPI_RXFRn_ADDR(x, n))
#define HW_SPI_RXFRn_RD(x, n)    (HW_SPI_RXFRn(x, n).U)
/*@}*/

/*
 * Constants & macros for individual SPI_RXFRn bitfields
 */

/*!
 * @name Register SPI_RXFRn, field RXDATA[31:0] (RO)
 *
 * Contains the received SPI data.
 */
/*@{*/
#define BP_SPI_RXFRn_RXDATA  (0U)          /*!< Bit position for SPI_RXFRn_RXDATA. */
#define BM_SPI_RXFRn_RXDATA  (0xFFFFFFFFU) /*!< Bit mask for SPI_RXFRn_RXDATA. */
#define BS_SPI_RXFRn_RXDATA  (32U)         /*!< Bit field size in bits for SPI_RXFRn_RXDATA. */

/*! @brief Read current value of the SPI_RXFRn_RXDATA field. */
#define BR_SPI_RXFRn_RXDATA(x, n) (HW_SPI_RXFRn(x, n).U)
/*@}*/

/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/*******************************************************************************
 * hw_spi_t - module struct
 ******************************************************************************/
/*!
 * @brief All SPI module registers.
 */
#pragma pack(1)
typedef struct _hw_spi
{
    __IO hw_spi_mcr_t MCR;                 /*!< [0x0] Module Configuration Register */
    uint8_t _reserved0[4];
    __IO hw_spi_tcr_t TCR;                 /*!< [0x8] Transfer Count Register */
    union {
        __IO hw_spi_ctarn_t CTARn[2];      /*!< [0xC] Clock and Transfer Attributes Register (In Master Mode) */
        __IO hw_spi_ctarn_slave_t CTARn_SLAVE[1]; /*!< [0xC] Clock and Transfer Attributes Register (In Slave Mode) */
    };
    uint8_t _reserved1[24];
    __IO hw_spi_sr_t SR;                   /*!< [0x2C] Status Register */
    __IO hw_spi_rser_t RSER;               /*!< [0x30] DMA/Interrupt Request Select and Enable Register */
    union {
        __IO hw_spi_pushr_t PUSHR;         /*!< [0x34] PUSH TX FIFO Register In Master Mode */
        __IO hw_spi_pushr_slave_t PUSHR_SLAVE; /*!< [0x34] PUSH TX FIFO Register In Slave Mode */
    };
    __I hw_spi_popr_t POPR;                /*!< [0x38] POP RX FIFO Register */
    __I hw_spi_txfrn_t TXFRn[4];           /*!< [0x3C] Transmit FIFO Registers */
    uint8_t _reserved2[48];
    __I hw_spi_rxfrn_t RXFRn[4];           /*!< [0x7C] Receive FIFO Registers */
} hw_spi_t;
#pragma pack()

/*! @brief Macro to access all SPI registers. */
/*! @param x SPI module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_SPI(SPI0_BASE)</code>. */
#define HW_SPI(x)      (*(hw_spi_t *)(x))

/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma pop
#elif defined(__CWCC__)
  #pragma pop
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

#endif /* __HW_SPI_REGISTERS_H__ */
/* EOF */
