#include "mbed.h"

class dPrell
{
    public:
    dPrell(PinName pin):data(pin),interrupt(pin)
    {
        time = 500;
        Run();
        interrupt.rise(this,&dPrell::druck);
        interrupt.fall(this,&dPrell::druck);
    }
    void rise(void (*fptr)(void))
    {
        press.attach(fptr);
    }
    void fall(void (*fptr)(void))
    {
        release.attach(fptr);
    }
    void setTime(timestamp_t in)
    {
        time = in;
    }
    void mode(PinMode mode)
    {
        interrupt.mode(mode);
    }
    void trig()
    {
        Run();
    }
    protected:
    void druck()
    {
        if (last == data)
            return;
        else 
        {
            if (data&En)
            {
                    press.call();
                    En=0;
                    res.attach_us(this,&dPrell::Run,time);
            }
            if((data==0)&En)
            {
                release.call();
                En=0;
                res.attach_us(this,&dPrell::Run,time);
            }
        }
        last = data;
    }
    void Run()
    {
        last = data;
        En = 1;
    }
    timestamp_t time;
    DigitalIn data;
    Timeout res;
    InterruptIn interrupt;
    char last;
    char En;
    FunctionPointer  press;
    FunctionPointer  release;
};