#include "mbed.h"
#include "DigitDisplay.h"
#include "WS2812B.h"
#include "PCF8563.h"

#define rGb (0x0f0000)  //Rot
#define Rgb (0x00ff00)  //Grün
#define rgB (0x0000ff)  //Blau
#define RgB (0x00ffff)  //Violet
#define rGB (0xff00ff)  //Türkis
#define RGb (0xffff00)  //Rot-Grün
#define RGB (0xffffff)  //Weiß
#define rgb (0x000000)  //Aus
//halbe Helligkeit
#define hrGb (0x0f0000)  //Rot
#define hRgb (0x000f00)  //Grün
#define hrgB (0x00000f)  //Blau
#define hRgB (0x000f0f)  //Violet
#define hrGB (0x0f000f)  //Türkis
#define hRGb (0x0f0f00)  //Rot-Grün
#define hRGB (0x0f0f0f)  //Weiß

 
Timeout timer;
PCF8563 rtc;

DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);
 
InterruptIn Taster1(p17);
InterruptIn Taster2(p18);
InterruptIn Taster3(p19);
InterruptIn Taster4(p20);
InterruptIn InternTaster1(P1_16);
InterruptIn InternTaster2(P0_23);
InterruptIn InternTaster3(P0_10);
InterruptIn InternTaster4(P0_15);

PwmOut Summer(p6);
 
LedOut RGBStripe(p25);
//                       (CLK, I/O)
DigitDisplay TimerDisplay(p21, p22);
//                     (CLK, I/O)
DigitDisplay UhrDisplay(p23, p24);
uint8_t hour, minute, sec;

int zahl =02;  // Schmiedi mach was mit den Tastern, dass man die Zahl einstellen kann
int second = 00;
int t;
int h;
int z;
int e;
bool colon = true;
int vergleich=(zahl*60);


int color;

Serial pc(USBTX, USBRX);

void berechne()
{
    t= zahl/10;
    h= (zahl-(t*10))/1;
    z= second/10;
    e= (second-(z*10))/1;
}

void ausgabe()
{
    TimerDisplay.write(0, t);
    TimerDisplay.write(1, h);
    TimerDisplay.write(2, z);
    TimerDisplay.write(3, e);
    pc.printf("\n %d %d : %d %d"  ,t, h ,z,e);

}





void StripeOut()
{
    __disable_irq();            //Interrupt deaktivieren

    for(int r=0; r<=10; r++)
        RGBStripe.WriteLed(color);  //Farbe rausschreiben

    __enable_irq();             //Interrupt reaktivieren
}

void UhrOut()
{
    hour = rtc.read(HOURS);
    minute = rtc.read(MINUTES);
    sec = rtc.read(SECONDS);

    UhrDisplay.write(0, (minute >> 4)- 8);
    UhrDisplay.write(1, (minute & 0x0F));
    UhrDisplay.setColon(1);
    UhrDisplay.write(2, (sec >> 4)- 8);
    UhrDisplay.write(3, (sec & 0x0F));
    
    }
    
void changecolor()
{
    color = hRGb;
}

int main()
{


    while(1) {


       
        for( int x = (zahl+1); x > 0; x--) {
           

            for (int y=second; y > 0; y--) {
                
                //color = hrGb;
             
             //  timer.attach(&changecolor, vergleich*0.2);
               if((y+x*60)<=vergleich*0.2)
                color = hRGb;
                
                else
                color = hrGb;
                
                TimerDisplay.setColon(colon);

                second--;
                berechne();
                ausgabe();
                StripeOut();
                UhrOut();
                wait(0.2);

            }

            zahl--;
            second = 60;

           
        }

        TimerDisplay.on();
        wait(0.5);
        TimerDisplay.off();
        wait(0.5);

    }
}
