#include "mbed.h"
#include "const.h"
#include "PCF8563.h"
#include "string"
 
Serial pc(USBTX, USBRX);
//I2C i2c(p28, p27);
 
uint8_t year, month, day, week;
uint8_t hour, minute, sec;
char week_chr[7][4] = {"MON","TUE","WED","THU","FRI","SAT","SUN"};
 
int main()
{
    PCF8563 rtc;  // instanziieren des Objektes rtc
 
    pc.printf("Setting up RTC\n\r");
    //rtc.rtc_init();
 
    while(1) {
        //printTime();           
        year = rtc.read(YEARS);   // Aufruf der Methode rtc_read der Instanz (Objekt) rtc
        month = rtc.read(MONTHS);
        day = rtc.read(DAYS);
        week = rtc.read(WEEKDAYS);
        hour = rtc.read(HOURS);
        minute = rtc.read(MINUTES);
        sec = rtc.read(SECONDS);
 
        //Datum Ausgabe
        pc.printf("20%x%x/%x%x/%x%x %s\n\r",
                  ((year >> 4) & 0x03) , (year & 0x0F) ,
                  ((month >> 4) & 0x01), (month & 0x0F) ,
                  ((day >> 4) & 0x03), (day & 0x0F) ,
                  week_chr[week & 0x07]);
 
        //Zeit Ausgabe
        pc.printf("%x%x:%x%x:%x%x\n\r",
                  ((hour >> 4) & 0x03), (hour & 0x0F),
                  (minute >> 4), (minute & 0x0F) ,
                  (sec >> 4), (sec & 0x0F) );
        wait(1);
    }
}