#include "mbed.h"
#include "WS2812B.h"
#include "PCF8563.h"
#include "DigitDisplay.h"

//             G R B
//             | | |
#define rGb (0x0f0000)  //Rot
#define Rgb (0x00ff00)  //Grün
#define rgB (0x0000ff)  //Blau
#define RgB (0x00ffff)  //Violet
#define rGB (0xff00ff)  //Türkis
#define RGb (0xffff00)  //Rot-Grün
#define RGB (0xffffff)  //Weiß
#define rgb (0x000000)  //Aus
//halbe Helligkeit
#define hrGb (0x0f0000)  //Rot
#define hRgb (0x000f00)  //Grün
#define hrgB (0x00000f)  //Blau
#define hRgB (0x000f0f)  //Violet
#define hrGB (0x0f000f)  //Türkis
#define hRGb (0x0f0f00)  //Rot-Grün
#define hRGB (0x0f0f0f)  //Weiß

PCF8563 rtc;

DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);

InterruptIn Taster1(p17);
InterruptIn Taster2(p18);
InterruptIn Taster3(p19);
InterruptIn Taster4(p20);
InterruptIn InternTaster1(P1_16);
InterruptIn InternTaster2(P0_23);
InterruptIn InternTaster3(P0_10);
InterruptIn InternTaster4(P0_15);

PwmOut Summer(p6);

LedOut RGBStripe(p25);
//                       (CLK, I/O)
DigitDisplay TimerDisplay(p21, p22);
//                     (CLK, I/O)
DigitDisplay UhrDisplay(p23, p24);

uint8_t hour, minute, sec;

int color = rgb;
int prozent = 0;

void StripeOut();
void TimerOut();
void UhrOut();
void SummerOut();
void Set();
void Plus();
void Minus();
void StartStop();

int main()
{
    Taster1.rise(&Set);
    Taster2.rise(&Plus);
    Taster3.rise(&Minus);
    Taster4.rise(&StartStop);
    InternTaster1.rise(&Set);
    InternTaster2.rise(&Plus);
    InternTaster3.rise(&Minus);
    InternTaster4.rise(&StartStop);

    prozent = 10;
    color=RGB;
    StripeOut();
    prozent = 0;
    while(1) {
        color = rgb;
        StripeOut();
        wait(0.2);
        prozent++;
    }
}

void StripeOut()
{
    __disable_irq();            //Interrupt deaktivieren

    for(int r=1; r<=prozent; r++)
        RGBStripe.WriteLed(color);  //Farbe rausschreiben

    __enable_irq();             //Interrupt reaktivieren
}

void TimerOut()
{
    TimerDisplay.write(0, 7);
    TimerDisplay.write(1, 3);
    TimerDisplay.setColon(1);
    TimerDisplay.write(2, 5);
    TimerDisplay.write(3, 3);
}

void UhrOut()
{
    hour = rtc.read(HOURS);
    minute = rtc.read(MINUTES);
    sec = rtc.read(SECONDS);

    UhrDisplay.write(0, (minute >> 4)- 8);
    UhrDisplay.write(1, (minute & 0x0F));
    UhrDisplay.setColon(1);
    UhrDisplay.write(2, (sec >> 4)- 8);
    UhrDisplay.write(3, (sec & 0x0F));
}

void SummerOut()
{
    // specify period first, then everything else
    Summer.period(0.001f);  // 4 second period
    Summer.pulsewidth(0.0004); // 2 second pulse (on)
    // led flashing
    while(1);
}

void Set()
{
    __disable_irq();
    Led1=!Led1;
    wait(0.5);
    __enable_irq();
}
void Plus()
{
    __disable_irq();
    Led2=!Led2;
    wait(0.5);
    __enable_irq();
}
void Minus()
{
    __disable_irq();
    Led3=!Led3;
    wait(0.5);
    __enable_irq();
}
void StartStop()
{
    __disable_irq();
    Led4=!Led4;
    wait(0.5);
    __enable_irq();
}