//______________________________________________________Bibliotheken
#include "mbed.h"
#include "WS2812B.h"
#include "PCF8563.h"
#include "DigitDisplay.h"
#include "dPrell.h"
//______________________________________________________Farbdefinitionen
//             G R B
//             | | |
#define rGb (0xff0000)  //Grün
#define Rgb (0x00ff00)  //Rot
#define rgB (0x0000ff)  //Blau
#define RgB (0x00ffff)  //Violet
#define rGB (0xff00ff)  //Türkis
#define RGb (0xffff00)  //Gelb
#define RGB (0xffffff)  //Weiß
#define rgb (0x000000)  //Aus
//halbe Helligkeit
#define hrGb (0x0f0000)  //Grün
#define hRgb (0x000f00)  //Rot
#define hrgB (0x00000f)  //Blau
#define hRgB (0x000f0f)  //Violet
#define hrGB (0x0f000f)  //Türkis
#define hRGb (0x0f0f00)  //Gelb
#define hRGB (0x0f0f0f)  //Weiß
//______________________________________________________Schnittstellen
Ticker TickerOutput;

PCF8563 rtc;

DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);

dPrell Taster1(p17);
dPrell Taster2(p18);
dPrell Taster3(p19);
dPrell Taster4(p20);
dPrell InternTaster1(P1_16);
dPrell InternTaster2(P0_23);
dPrell InternTaster3(P0_10);
dPrell InternTaster4(P0_15);

PwmOut Summer(p6);

LedOut RGBStripe(p25);
//                       (CLK, I/O)
DigitDisplay TimerDisplay(p21, p22);
//                     (CLK, I/O)
DigitDisplay UhrDisplay(p23, p24);

Serial pc(USBTX, USBRX);
//______________________________________________________Variablen

uint8_t hour, minute, sec;

int color = rgb;
int ColorTime = 0;
int Prozent = 10;
int TimerZeit = 0;
int TimerMinuten = 0;
int TimerSekunden = 0;
int UhrZeit = 0;
int VergleichsZeitEins = 0;
int VergleichsZeitZwei = 0;

bool SetMenu = 0;
bool StartStop = 0;
bool Berechnung = 0;
bool End = 0;
//______________________________________________________Funktionen

void Set();
void Plus();
void Minus();
void TimerStartStop();
void TasterTrig();

void TimerIn();
void TimerPlay();
void TimerOut();
void VergleichsZeit();
void ColorChangeTime();
void ColorProzentTime();
void StripeOut();
void UhrOut();
void SummerOut();
void Output();
void EndSignal();
//______________________________________________________Main
int main()
{
    TickerOutput.attach(&Output, 0.2);

    Taster1.rise(&Set);
    Taster2.rise(&Plus);
    Taster3.rise(&Minus);
    Taster4.rise(&TimerStartStop);
    InternTaster1.rise(&Set);
    InternTaster2.rise(&Plus);
    InternTaster3.rise(&Minus);
    InternTaster4.rise(&TimerStartStop);
    while(1) {
        if(SetMenu == 0 && (TimerMinuten > 0 || TimerSekunden > 0) && StartStop == 1) {
            VergleichsZeit();
            TimerPlay();
        } else if(SetMenu == 0 && StartStop == 1) {
            StartStop = 0;
        }
        if(End == 1) {
            EndSignal();
        }
    }
}
//______________________________________________________Interrupts

void Set()
{
    Led1 = !Led1;
    if (SetMenu == 0 && StartStop == 0) {
        SetMenu = 1;
    } else if (SetMenu == 1 && StartStop == 0) {
        SetMenu = 0;
    }
    End = 0;
    Summer.pulsewidth(0);
    Berechnung = 0;
    TasterTrig();
}
void Plus()
{
    Led2 = !Led2;
    if(SetMenu == 1) {
        TimerMinuten++;
        TimerSekunden = 0;
    }
    TasterTrig();

}
void Minus()
{
    Led3 = !Led3;
    if(SetMenu == 1 && minute>0) {
        TimerMinuten--;
        TimerSekunden = 0;
    }
    TasterTrig();

}
void TimerStartStop()
{
    Led4 = !Led4;
    if(SetMenu == 0 && (TimerMinuten > 0 || TimerSekunden > 0) && StartStop == 0) {
        StartStop = 1;
    } else if(SetMenu == 0 && StartStop ==1) {
        StartStop = 0;
    }
    Berechnung = 1;
    TasterTrig();
}
//______________________________________________________Funktionen

void TasterTrig()
{
    Taster1.trig();
    Taster2.trig();
    Taster3.trig();
    Taster4.trig();
    InternTaster1.trig();
    InternTaster2.trig();
    InternTaster3.trig();
    InternTaster4.trig();
}
//______________________________________________________Timer-Bereich

void TimerPlay()
{
    while(TimerMinuten > 0) {
        if(TimerSekunden == 0) {
            TimerMinuten--;
            TimerSekunden = 60;
        }
        while(TimerSekunden >0) {
            TimerSekunden--;
            wait(1);
            if(StartStop == 0) {
                return;
            }
        }
    }
    if(TimerMinuten < 1 && TimerSekunden < 1) {
        End = 1;
        StartStop = 0;
    }
    return;
}

void TimerOut()
{
    TimerZeit = (TimerMinuten * 100) + TimerSekunden;
    TimerDisplay.write(TimerZeit);
    TimerDisplay.setColon(1);
}
//______________________________________________________RGB-,Uhr-,Summer-Bereich
void VergleichsZeit()
{
    if (Berechnung == 1) {
        VergleichsZeitEins = TimerMinuten * 60;
        Berechnung = 0;
    }
}

void ColorChangeTime()
{
    VergleichsZeitZwei = (TimerMinuten * 60) + TimerSekunden;

    if (SetMenu == 0 && VergleichsZeitZwei <= VergleichsZeitEins * 0.2 && VergleichsZeitZwei > 0) {
        color = RGb;
    } else if (SetMenu == 0 && VergleichsZeitZwei == 0) {
        color = Rgb;
    } else if (SetMenu == 0 && VergleichsZeitZwei > VergleichsZeitEins * 0.2){
        color = rGb;
    } else if (SetMenu == 1){
        color = rgB;
    } else {
        color = rgb;
    }
}

void ColorProzentTime()
{

}

void StripeOut()
{
    __disable_irq();            //Interrupt deaktivieren

    for(int r=1; r<=Prozent; r++)
        RGBStripe.WriteLed(color);  //Farbe rausschreiben

    __enable_irq();             //Interrupt reaktivieren
}

void UhrOut()
{
    hour = rtc.read(HOURS);
    minute = rtc.read(MINUTES);
    sec = rtc.read(SECONDS);

    UhrDisplay.write(0, (hour >> 4) & 0x03); //Stunden  -0x03
    UhrDisplay.write(1, (hour & 0x0F));
    UhrDisplay.setColon(1);
    UhrDisplay.write(2, (minute >> 4)- 8);  //Minuten und Sekunden -8
    UhrDisplay.write(3, (minute & 0x0F));
}

void SummerOut()
{
    // specify period first, then everything else
    Summer.period(0.001f);  // 0.001 second period
    Summer.pulsewidth(0.0004); // 0.0004 second pulse (on)
    // led flashing
    wait(4);
    Summer.pulsewidth(0);
}

void Output()
{
    ColorChangeTime();
    TimerOut();
    UhrOut();
    StripeOut();
}

void EndSignal()
{
    __disable_irq();
    Prozent = 10;
    SummerOut();
    Berechnung = 0;
    End = 0;
    __enable_irq();
}