#include "mbed.h"
#include "DebounceIn.h"

DigitalOut myled(LED1); //Indicator light to indicate the program is running
PwmOut motor(D2); //To MOSFET
//DigitalOut motor(D2); //Direct Drive the motor
DigitalOut clutch(D3); //Clutch power
DigitalOut indicRe(LED2); //Indicate Rear Switch State
DigitalOut indicFr(LED3); //Indicate Front Switch State
DigitalOut indicHOLD(LED4);
DebounceIn swiRe(D5); //Rear Limit Switch
DebounceIn swiFr(D6); //Front Sensor Switch
DebounceIn swiONOFF(D15); // Reset program switch

Timer t; //timer for last fr hit
int cuttFr = 1000; //ms time front
int cuttRe = 500; //ms time rear
bool prevSwi = 0; //previously hit switch -- 0 Re, 1 Fr
bool motorSo = 0;

int count = 0; //count of cycles


int main() {
    myled = 1;
    wait(0.2);
    myled = 0;
    wait(0.2);
    myled = 1;
    wait(0.2);
    myled = 0;
    wait(0.2);
    myled = 1;
    t.start();
    printf("Start!\n");
    while(1) {
        if (swiONOFF) {
            wait(.5);
            while(~swiONOFF){
                indicHOLD = 0;
                }
            NVIC_SystemReset();
            }
        if (swiFr){
            indicFr = 0;
            wait(.2);
            if (swiRe==0){
                indicFr = 0;
                indicRe = 1;
                clutch = 1;
                wait(.05);
                motor.write(0.20f);
                wait(.1);
                motor.write(0.40f);
                wait(.1);
                motor.write(0.60f);
                wait(.1);
                motor.write(0.80f);
                wait(.1);
                motor.write(1.00f);                
                }
            while (swiRe==0){
                indicFr = 0;
                indicRe = 1;
                myled = 0;
                //motor.write(1.00f);
                }
            indicRe = 0;
            indicFr = 1;
            myled = 1;
            clutch = 0;
            motor= 0;
            count++;
            printf("Motor State Switch!! %d cycles \n",count);
            }
        else {
            indicRe = 1;
            indicFr = 1;
            }

    }
}

