#include "mbed.h"
#include "DebounceIn.h"

DigitalOut myled(LED1); //Indicator light to indicate the program is running
PwmOut motor(D2); //To MOSFET
DigitalOut indicRe(LED2); //Indicate Rear Switch State
DigitalOut indicFr(LED3); //Indicate Front Switch State
//DigitalOut indicHa(LED4); //Indicate Hall Switch State
DebounceIn swiRe(D5); //Rear Limit Switch
DebounceIn swiFr(D3); //Front Limit Switch
DebounceIn swiHa(D4); //HE Sensor Switch

Timer t; //timer for last fr hit
int cuttFr = 1000; //ms time front
int cuttRe = 500; //ms time rear
bool prevSwi = 0; //previously hit switch -- 0 Re, 1 Fr
bool motorSo = 0;

int count = 0; //count of cycles


int main() {
    myled = 1;
    wait(0.2);
    myled = 0;
    wait(0.2);
    myled = 1;
    wait(0.2);
    myled = 0;
    wait(0.2);
    myled = 1;
    t.start();
    printf("Start!\n");
    while(1) {
        if (swiHa){
            indicFr = 0;
            wait(.75);
            if (swiRe==0){
                indicFr = 0;
                indicRe = 1;
                
                myled = 0;
                motor.write(0.25f);
                wait(.2);
                motor.write(0.35f);
                wait(.2);
                motor.write(0.45f);
                wait(.2);
                motor.write(0.55f);
                wait(.1);
                motor.write(0.65f);
                wait(.1);
                motor.write(0.75f);
                wait(.1);
                motor.write(0.85f);
                wait(.1);
                motor.write(0.95f);
                wait(.1);
                motor.write(1.00f);
                } 
                
            while (swiRe==0){
                indicFr = 0;
                indicRe = 1;
                myled = 0;
                //motor.write(1.00f);
                }
            indicRe = 0;
            indicFr = 1;
            myled = 1;
            //wait(1);
            motor.write(0.0f);
            count++;
            printf("Motor State Switch!! %d cycles \n",count);
            }
        else {
            indicRe = 1;
            indicFr = 1;
            }

    }
}
