
#include "mbed.h"
#include "MCP4922.h"

MCP4922 MCP(SPI_MOSI, SPI_SCK,PB_6);  // MOSI, SCLK, CS


/**** Main Function  ***/
int main(void)
{
    MCP.frequency(3125000);

    uint16_t i=0;
    int state=0;
    while(1) {
        if(i < 0x07FF) {
            i++;
        } 
        else {
            i=0;
            if (state == 0 ){
                state = 1;    
            }
            else if(state == 1) {
                state = 2;
            }
            else if(state == 2){
                state = 3;
            }
            else if(state == 3){
                state = 0;
            }
        }

        if(state ==0) {
            MCP.writeA(i);
        }
        else if (state == 1){
            MCP.writeA( ((~i))&0x07FF);
        }
        else if (state == 2){
            MCP.writeA( ((~i))&0x0FFF);
        }
        else if (state == 3){
            MCP.writeA(i+0x07FF);
        }
        wait_us(2);
    }
}