#include "mbed.h"

Serial pc(D8,D2);
//Serial pc(D1,D0);

AnalogIn analog_value(A1);
BusOut mySegment(D9, D10, D11, D12);

float meas_r; 
float meas_mv;         
float meas_v;

int main(){
    
    uint8_t mode;
    uint8_t dataIn;
    uint8_t state_show=0;
    uint8_t guide=0;
    uint8_t mode_exit = 0;
    
    while(1){
        if(state_show == 0) {
            pc.printf("#############\n");
            pc.printf("     Menu   \n");
            pc.printf("#############\n");
            pc.printf("1.Segment show input number\n");
            pc.printf("2.Monitor input voltage\n");
            state_show =1;
        }
        if(pc.readable()) {
            mode = pc.getc();
            pc.printf("\n");
            state_show=0;
            mode_exit = 0;
            guide = 0;
            switch(mode) {
                
                case '1':    //Segment show input number
                    do{
                        
                        if(guide == 0){
                            pc.printf("##########################\n");
                            pc.printf("Segment show input number\n");
                            pc.printf("##########################\n");
                            pc.printf("Please key any number\n"); 
                            pc.printf("key x to exit\n"); 
                            guide = 1;
                        }
                        if(pc.readable()) {
                            dataIn = pc.getc();
                            if(dataIn == 'x'){
                                pc.printf("\n");
                                mode_exit = 1;
                            }
                            else{
                                mySegment = dataIn;
                                pc.printf("number = %c \n\n",(char)dataIn);
                                guide = 0;
                            }
                        }
                        
                    }while(mode_exit ==0);
                    break;
                    
                case '2':      //Monitor input voltage
                    do{
                        if(pc.readable()) {
                            dataIn = pc.getc();
                            if(dataIn == 'x'){
                                mode_exit = 1;
                            }
                        }
                        meas_r = analog_value.read(); 
                        meas_mv = meas_r * 3300;         
                        meas_v = (float)meas_mv / 1000;
                        pc.printf("Input voltage = %.2f V.       key x to exit\n",meas_v); 
                        
                    }while(mode_exit ==0);
                    break;
                    
                default:
                    pc.printf("plz select 1 or 2 only\n");
                    pc.printf("\n");
                    break;
                    
                
            }
        }
    }

}
