#include "mbed.h"

AnalogIn analog_value(A2);
DigitalIn button(USER_BUTTON);

DigitalOut d1(D11);
DigitalOut c1(D10);
DigitalOut b1(D9);
DigitalOut a1(D8);
DigitalOut d2(D5);
DigitalOut c2(D4);
DigitalOut b2(D3);
DigitalOut a2(D2);

BusOut myled(PA_11,PB_12,PB_2,PB_1,PB_15,PB_14,PB_13,PC_4);

float meas_r;
int meas_mv;
int meas_v;
int meas_vf;
int state;
int preState;
int buttonState;
int vuStatus,segmentStatus;

            
void Segment(){
    int i,j;
    int bin1[4]= {0};
    int bin2[4]= {0};
    i = 0, j = 0;
    do {
        bin1[i++] = meas_v % 2;
        meas_v = meas_v / 2;
    }while(meas_v > 0);
    do {
        bin2[j++] = meas_vf % 2;
        meas_vf = meas_vf / 2;
    }while(meas_vf > 0);
//    printf("SSSS = %d = %d = %d = %d \n", second[0],second[1],second[2],second[3]); 
    d1 = bin1[3];
    c1 = bin1[2];
    b1 = bin1[1];
    a1 = bin1[0];
    d2 = bin2[3];
    c2 = bin2[2];
    b2 = bin2[1];
    a2 = bin2[0];           
}

void checkState(){
    preState = state;
    while (1){
        if (meas_mv < 412.5){
            state = 1;
            break;
        }
        if (meas_mv >= 412.5 && meas_mv < 825 ){
            state = 2;
            break;
        }
        if (meas_mv >= 825 && meas_mv < 1237.5 ){
            state = 3;
            break;
        }
        if (meas_mv >= 1237.5 && meas_mv < 1650 ){
            state = 4;
            break;
        }
        if (meas_mv >= 1650 && meas_mv < 2062.5 ){
            state = 5;
            break;
        }
        if (meas_mv >= 2062.5 && meas_mv < 2475 ){
            state = 6;
            break;
        }
        if (meas_mv >= 2475 && meas_mv < 2887.5 ){
            state = 7;
            break;
        }
        if (meas_mv >= 2887.5){
            state = 8;
            break;
        }
    }
}

void segmentSeto(){
    d1 = 0,c1 = 0,b1 = 0,a1 = 0,d2 = 0,c2 = 0,b2 = 0,a2 = 0;   
}

void vuSet0(){
    int m;
    for ( m = 0;m <8 ;m++){
        myled[m] = 0;
    }
}

void vuMeter(){
    int k;
    k = 0;
    if(preState > state){
        vuSet0();
    }
    while(vuStatus){
        checkState();
        do{
            myled[k++] = 1;        
        }while(k < state);
        break;
    }    
}

void checkButton(){
    int preB;
    //buttonState = 0;
    preB = buttonState;
    if(button == 0){
        if (preB == 0){
            buttonState = 1;
        }
        if (preB == 1){
            buttonState = 0;
        }
        wait(0.5);
        
    }
    printf("preButton = %d",preB);
    printf("buttonState = %d",buttonState);
    
    
}

int main()
{   state = 0;

    while(1) {

        meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        meas_mv = meas_r * 3300; // Converts value in the 0V-3.3V range
        meas_v = meas_mv / 1000;
        meas_vf = (meas_mv % 1000)/100;
        
        // Display values
//        printf("measure = %f = %d mV = %d V = %d Vf\n", meas_r, meas_mv, meas_v, meas_vf);
//        Segment();
//        vuMeter();
//        printf("State = %d \n",state);
//        printf("Prestate = %d \n",preState);
        checkButton();
        if (buttonState == 0){
            segmentSeto();
            vuMeter();
            vuStatus = 1;
            segmentStatus = 0;
        }
        else if (buttonState == 1){
            vuSet0();
            Segment();
            vuStatus = 0;
            segmentStatus = 1;
            
        }
        printf("vu = %d = seg = %d \n",vuStatus,segmentStatus);
        

    }
}
