#include "mbed.h"
#include "keypad.h"

int dim=4;
Serial pc(USBTX, USBRX);
Keypad keypad(D6,D5,D4,D3,D10,D9,D8,D7); //porte del tastierino
char pass[4]={'1','2','3','4'}; //password di default (è possibile cambiarla dal menu)
DigitalOut buz(D2); //porta buz
DigitalIn mag(D11); //porta del magnete
bool alonoff=true;  //variabile booleana per abilitare o disabilitare l'allarme in caso di apertura e chiusura (?)
void inserimento(char[],int); //funzione per inserire parametri dal tastierino
void menu(); //funzione per andare al menu (dove è possibile cambiare pas, aprire ecc...
void alarm(); //funzione allarme (attiva il buz e fa inserire il codice per la disattivazione)
int i=0;
int main(){
    char vet[dim];
    int cont;
    int tent=0;                    //MANCA LA PARTE RELATIVA AL MAGNETICO (Magnetico aperto(mag=0) => suona se l'allarme è inserito)
    do{                                                 
        cont=0;
        pc.printf("Insert password: "); //inserimento della password
        inserimento(vet,dim);
    
        for(int p=0;p<dim;p++){    //confronto con la password 
            if (vet[p]==pass[p]){
                cont++;
                }
            }
        
        if (cont==dim){ //se il confronto è andato bene vai al menu e disattiva l'allarme
            pc.printf("The password is correct \n");
            alonoff=false;
            menu();
            }
        if(cont!=dim){ //se il confronto non è andato incrementa i tentativi e si riparte da capo
            pc.printf("Password not valid");
            tent++;
            if (tent==3){ //se i tentativi sono più di tre chiama la funzione allarme
                alarm();
                }
            }
            }while(1); //il while(1) permette di ripetere l'operazione di continuo, si esce solo
}                       //saltanto alla funzione allarme o menu, dalle due funzioni poi si potrà
                            //ritornare al main richiamandolo da capo.
void inserimento(char a[],int n){ //funzione di acquisizione dal tastierino
    i=0;
    do{
    keypad.enablePullUp();
    char val = keypad.getKey();
        if(val != KEY_RELEASED){ //se qualche tasto è premuto stampalo e mettilo nell'array  
                    pc.printf("%c ",val);
                    a[i]=val;
                    i++;
                    wait(0.4);
                }
                
        }while(i<n); //ripeti fino alla dimensione dell'array richiesto
}

void menu(){ //funzione menu (si accede quando la password è corretta)
    
    pc.printf("A to open, B to Block, C to Change password ");
    char val;
    do{
        inserimento(&val,1); //inserimento dell'opzione scelta dal tastierino (in questo caso la dimensione è 1 e poichè la funzione
        if(val!='A' && val!='B' && val!='C'){ //accetta solo variabile indirizzo bisogna mandare l'indirizzo di val)
            pc.printf("Not Valid");     //se il valore è diverso da A, B o C ripeti l'inserimento.
            }
    }while(val!='A' && val!='B' && val!='C');
    
    if(val=='A'){                                   //MANCA APERTURA CON SERVO
        pc.printf("Opening... \n"); //apertura col servo e disattivazione dell'allarme (altrimenti se il magnetico si apre
        menu();                     //si va in allarme)
        }
    if(val=='B'){                                   //MANCA CHIUSURA CON SERVO
        pc.printf("Closing...");        //chiusura servo e abilitazione allarme, ritorno al reinserimento pass.
        wait(4);
        alonoff=true;
        main();
        }
    if(val=='C'){       //cambio password:
        char v[dim];
        pc.printf("Enter new password: ");
        inserimento(v,dim);
        pc.printf("New password is %c %c %c %c, push A to confirm or C to cancel",v[0],v[1],v[2],v[3]);
        inserimento(&val,1); //conferma della password inserita
        do{
            if(val=='A'){           //A=> Cambia la password con quella inserita e torna nel main (dove bisognerà, per
                pc.printf("Password changed \n");   //accedere al menu inserire di nuovo la password)
                for(int k=0;k<dim;k++){
                    pass[k]=v[k];
                    }
                    main();
                }
            if(val=='C'){       //C=>Non cambiare la password e torna di nuovo al menu
                menu();
                }
            if(val!='A' && val!='C'){ //inserimento fin quando il valore è A o C.
                pc.printf("Not valid \n");
                }
            }while(val!='A' && val!='C');  
    }
}
void alarm(){   //funzione allarme: (DA RIVEDERE)
        int cont=0;
        char insa[dim];                     //DA VEDERE !!!!
        do{                 //il buz deve suonare durante l'inserimento della password corretta
            buz=1;          //per disattivare l'allarme stesso e accedere al menu
            wait(0.5);
            buz=0;
            wait(0.5);
            
                inserimento(insa,dim);
                for(int h=0;h<dim;h++){
                   if(insa[h]==pass[h]){
                        cont++;
                    }
                }
            
                if(cont==dim){
                    menu();
                    cont=0;
                    }
                if (cont!=dim){
                    pc.printf("Password not valid \n");
                    cont=0;
                    }
            
            }while(1);
        
}