#include "Cassaforte.h"
#include "TextLCD.h"
#include "Servo.h"
#include "keypad.h"
I2C i2c(D14, D15);
//InterruptIn button(PC_13);
TextLCD_I2C lcd(&i2c, 0x4E, TextLCD_I2C::LCD16x2, TextLCD_I2C::HD44780);
DigitalOut led(LED1);
Servo servo(D11);
int dim=4;
Keypad keypad(D6,D5,D4,D3,D10,D9,D8,D7); //porte del tastierino
char pass[4]={'1','2','3','4'}; //password di default (è possibile cambiarla dal menu)
DigitalOut buz(D2); //porta buz
DigitalIn mag(D1); //porta del magnete
bool alonoff=true;  //variabile booleana per abilitare o disabilitare l'allarme in caso di apertura e chiusura (?)

void inizializza(){
    lcd.setMode(TextLCD_I2C::DispOn);
    lcd.setCursor(TextLCD_I2C::CurOn_BlkOn);
    }

void scrivi(char parola[]){
    lcd.cls();
    lcd.printf("%s\n", parola);
    }
       
void chiuso(){
    servo.position(-90);
    
    }
    
void aperto(){
    servo.position(-90);
    
    }
void inserimento(char a[],int n){ //funzione di acquisizione dal tastierino
    keypad.enablePullUp();
    for(int k=0;k<n;k++){
    keypad.enablePullUp();
    char val = keypad.getKey();
        if(val != KEY_RELEASED){ //se qualche tasto è premuto stampalo e mettilo nell'array  
                    lcd.putc(val);
                    lcd.setAddress(k,1);
                    a[k]=val;
                    wait(0.4);
                }
                
        }
}
void menu(){ //funzione menu (si accede quando la password è corretta)
    
    scrivi("A to open, B to Block, C to Change password ");
    char val;
    do{
        inserimento(&val,1); //inserimento dell'opzione scelta dal tastierino (in questo caso la dimensione è 1 e poichè la funzione
        if(val!='A' && val!='B' && val!='C'){ //accetta solo variabile indirizzo bisogna mandare l'indirizzo di val)
            scrivi("Not Valid");     //se il valore è diverso da A, B o C ripeti l'inserimento.
            }
    }while(val!='A' && val!='B' && val!='C');
    
    if(val=='A'){  
        if(mag==1){                                 
            scrivi("Opening... \n");
            alonoff=false;
            aperto();
            wait(2);                            
            menu();                   
            }
        }
    if(val=='B'){  
        if(mag==0){                                 //MANCA CHIUSURA CON SERVO
            scrivi("Closing...");  
            alonoff=true;
            chiuso();      //chiusura servo e abilitazione allarme, ritorno al reinserimento pass.
            wait(2);
            main();
            }
        }
    if(val=='C'){       //cambio password:
        char v[dim];
        scrivi("Enter new password: ");
        inserimento(v,dim);
       // scrivi("New password is %c %c %c %c, push A to confirm or C to cancel",v[0],v[1],v[2],v[3]);
        scrivi("Il codice è:");
        for(int i=0;i<4;i++){
            lcd.putc(v[i]);
            lcd.setAddress(i+13,0);
            }
        lcd.printf("A:ok, C:annulla");
        inserimento(&val,1); //conferma della password inserita
        do{
            if(val=='A'){           //A=> Cambia la password con quella inserita e torna nel main (dove bisognerà, per
                scrivi("Password changed \n");   //accedere al menu inserire di nuovo la password)
                for(int k=0;k<dim;k++){
                    pass[k]=v[k];
                    }
                    main();
                }
            if(val=='C'){       //C=>Non cambiare la password e torna di nuovo al menu
                menu();
                }
            if(val!='A' && val!='C'){ //inserimento fin quando il valore è A o C.
                scrivi("Not valid \n");
                }
            }while(val!='A' && val!='C');  
    }
}
void alarm(){   //funzione allarme: (DA RIVEDERE)
        int cont=0;
        char insa[dim];                     //DA VEDERE !!!!
        do{                 //il buz deve suonare durante l'inserimento della password corretta
            buz=1;          //per disattivare l'allarme stesso e accedere al menu
            wait(0.5);
            buz=0;
            wait(0.5);
            
                inserimento(insa,dim);
                for(int h=0;h<dim;h++){
                   if(insa[h]==pass[h]){
                        cont++;
                    }
                }
            
                if(cont==dim){
                    menu();
                    cont=0;
                    }
                if (cont!=dim){
                    scrivi("Password not valid \n");
                    cont=0;
                    }
            
            }while(1);
        
}