#include "motor.h"

float v_bat = 11.3f;     //モータ用電源電圧

/*-----使用するPWMモジュール-----*/
PwmOut *motor_L = &pwm2;
PwmOut *motor_R = &pwm1;
PwmOut *motor_lift = &pwm3;
/*----------------------------*/

/*--------回転方向制御I/O--------*/
DigitalOut ml_dir(PB_3);    //left motor
DigitalOut mr_dir(PB_4);    //right motor
DigitalOut me_dir(PB_10);    //lift motor (elevation)
/*-----------------------------*/

void Put_Vm_L(float v)
{
    if(v < 0.0f)
    {
        ml_dir = 1;
        (*motor_L).write(-v / v_bat);
    }
    else
    {
        ml_dir = 0;
        (*motor_L).write(v / v_bat);
    }
}

void Put_Vm_R(float v)
{
    if(v < 0.0f)
    {
        mr_dir = 1;
        (*motor_R).write(-v / v_bat);
    }
    else
    {
        mr_dir = 0;
        (*motor_R).write(v / v_bat);
    }
}

void Put_Vm_Lift(float v)
{
    if(v > 0.0f)
    {
        me_dir = 1;
        (*motor_lift).write(v / v_bat);
    }
    else
    {
        me_dir = 0;
        (*motor_lift).write(-v / v_bat);
    }
}