/* 
 * File:   pid.h
 * Author: Owner
 *
 * Created on 2016/02/29, 1:12
 */

#ifndef PID_H
#define	PID_H

#include <stdint.h>

#define PID_CONTROL_ENABLE      1
#define PID_CONTROL_DISABLE     0

typedef struct{
        
	float kp;
	float kd;
	float ki;
	float diff[2];
	float i_term;
	
	uint32_t is_enabled;
	uint32_t is_initialized;

} PID_Struct;

void PID_Struct_Init(PID_Struct *, float, float, float);
void PID_Enable_Control(PID_Struct *);
void PID_Disable_Control(PID_Struct *);
uint32_t PID_Check_Status(PID_Struct *);
float PID_Control(PID_Struct *, float, float);
float PD_Control(PID_Struct *, float, float);
float PI_Control(PID_Struct *, float, float);

#endif	/* PID_H */

