#ifndef __l3gd20_H
#define __l3gd20_H

#include "spi.h"
//#include "mxconstants.h"
#include <stdio.h>


#define L3GD20_RW 0x80

/*-------------------------------*/
#define WHO_AM_I    0x0F
#define CTRL_REG1   0x20
#define CTRL_REG2   0x21
#define CTRL_REG3   0x22
#define CTRL_REG4   0x23

#define OUT_TEMP    0x26

#define OUT_X_L     0x28
#define OUT_X_H     0x29
#define OUT_Y_L     0x2A
#define OUT_Y_H     0x2B
#define OUT_Z_L     0x2C
#define OUT_Z_H     0x2D
/*-------------------------------*/

typedef struct{
    
    int32_t x;
    int32_t y;
    int32_t z;
    
    int32_t temp;
    
    } gyro_t;
    
extern gyro_t l3gd20;

void L3GD20_Init();
void L3GD20_Read();

#endif