#include "MCP3208.h"

#define CS_GPIOx GPIOA
#define CS_GPIO_Pin GPIO_PIN_4

adc_t mcp3208;

/*----------------SPI module-----------------*/
static SPI *spi_ptr = &spi1;			//use SPI1
static DigitalOut *cs_ptr = &spi1_cs2;	//CS pin
/*-------------------------------------------*/

void MCP3208_Init()
{
	*cs_ptr = 1;	//CS high
}

void MCP3208_Read(uint8_t channel)
{
    *cs_ptr = 0;	//CS low
    (*spi_ptr).write(MCP3208_MODE_SINGLE | ((channel & 0x04) >> 2));
    spi_rx[1] = (*spi_ptr).write((channel & 0x03) << 6);
    spi_rx[2] = (*spi_ptr).write(0x00);											//dummy data
    *cs_ptr = 1;	//CS high
		
	mcp3208.adres[channel] = (((int32_t)spi_rx[1] << 8) + spi_rx[2]) & 0x0FFF;
}
